% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotROC.R
\name{plot.rocit}
\alias{plot.rocit}
\title{Plot ROC Curve}
\usage{
\method{plot}{rocit}(
  x,
  col = c("#2F4F4F", "#BEBEBE"),
  legend = TRUE,
  legendpos = "bottomright",
  YIndex = TRUE,
  values = TRUE,
  ... = NULL
)
}
\arguments{
\item{x}{An object of class \code{"rocit"},
returned by \code{\link{rocit}} function.}

\item{col}{Colors to be used in the plot. If multiple specified,
the first color is used for the ROC curve, and the second color is used for
the chance line (\eqn{y = x} line), otherwise single color is used.}

\item{legend}{A logical value indicating whether legends to appear in the plot.}

\item{legendpos}{Position of the legend. A single keyword from
\code{"bottomright"}, \code{"bottom"},
\code{"bottomleft"}, \code{"left"}, \code{"topleft"},
\code{"top"}, \code{"topright"}, \code{"right"} and \code{"center"},
as in \code{\link[graphics]{legend}}. Ignored if
\code{legend} is \code{FALSE}.}

\item{YIndex}{A logical value indicating whether optimal
\emph{Youden Index} (i.e where \eqn{|TPR - FPR| is maximum}) to
be marked in the plot.}

\item{values}{A logical value, indicating whether values to be returned.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\value{
If \code{values = TRUE}, then AUC, Cutoff, TPR, FPR,
optimal Youden Index with
associated TPR, FPR, Cutoff are returned silently.
}
\description{
This function generates receiver operating
characteristic (ROC) curve. This is an S3 method for object of class
\code{"rocit"}, returned by \code{\link{rocit}} function.
}
\note{
Customized plots can be made by using the
returned values of the function.
}
\examples{
data("Loan")
score <- Loan$Score
class <- ifelse(Loan$Status == "FP", 0, 1)
rocit_emp <- rocit(score = score, class = class)
# -----------------------
plot(rocit_emp)
plot(rocit_emp, col = c(2,4), legendpos = "bottom",
     YIndex = FALSE, values = FALSE)
# -----------------------
rocit_bin <- rocit(score = score, class = class, method = "bin")
# -----------------------
plot(rocit_emp, col = c(1,"gray50"), legend = FALSE, YIndex = FALSE)
lines(rocit_bin$TPR~rocit_bin$FPR, col = 2, lwd = 2)
legend("bottomright", col = c(1,2),
       c("Empirical ROC", "Binormal ROC"), lwd = 2)

}
