% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{composeTransforms}
\alias{composeTransforms}
\title{Compose transformations}
\usage{
composeTransforms(...)
}
\arguments{
\item{...}{Affine or nonlinear transforms, possibly obtained from
\code{\link{forward}} or \code{\link{reverse}}.}
}
\value{
The composed transform. If all arguments are affines then the result
  will also be an affine; otherwise it will be a deformation field.
}
\description{
Compute the composition of two or more transforms, the single transform that
combines their effects in order.
}
\note{
The source image for the composed transform is generally the source
  image from the first transform, and the target is the target image from
  the second transform. However, the target image attached to half
  transforms (as calculated by \code{\link{halfTransform}}) generally has a
  modified xform, compared to the original target. Therefore, composing a
  half transform with itself may not be exactly equivalent to the original.
}
\seealso{
\code{\link{niftyreg.linear}}, \code{\link{niftyreg.nonlinear}},
  \code{\link{deformationField}}
}
\author{
Jon Clayden <code@clayden.org>
}
