% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.r
\name{filter.window}
\alias{filter.window}
\title{Filter edges from the document similarity network based on hour difference}
\usage{
filter.window(g, hour.window, to.vertices = NULL, from.vertices = NULL)
}
\arguments{
\item{g}{A document similarity network, as created with \link[RNewsflow]{newsflow.compare} or \link[RNewsflow]{document.network}}

\item{hour.window}{A vector of length 2, in which the first and second value determine the left and right side of the window, respectively. For example, c(-10, 36) will compare each document to all documents between the previous 10 and the next 36 hours.}

\item{to.vertices}{A filter to select the vertices `to` which an edge is filtered. 
For example, if `V(g)$sourcetype == "newspaper"` is used, then the hour.window filter is only applied for edges `to` newspaper documents (specifically, where the sourcetype attribute is "newspaper").}

\item{from.vertices}{A filter to select the vertices `from` which an edge is filtered. 
Works identical to `to.vertices`.}
}
\value{
A network/graph in the \link[igraph]{igraph} class
}
\description{
The `filter.window` function can be used to filter the document pairs (i.e. edges) using the `hour.window` parameter, which works identical to the `hour.window` parameter in the `newsflow.compare` function. 
In addition, the `from.vertices` and `to.vertices` parameters can be used to select the vertices (i.e. documents) for which this filter is applied.
}
\details{
It is recommended to use the \link[RNewsflow]{show_window} function to verify whether the hour windows are correct according to the assumptions and focus of the study.
}
\examples{
data(docnet)
show.window(docnet, to.attribute = 'source') # before filtering

docnet = filter.window(docnet, hour.window = c(0.1,24))

docnet = filter.window(docnet, hour.window = c(6,36), 
                       to.vertices = V(docnet)$sourcetype == 'Print NP')

show.window(docnet, to.attribute = 'sourcetype') # after filtering per sourcetype
show.window(docnet, to.attribute = 'source') # after filtering per source
}
