% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{BAT}
\alias{BAT}
\title{Basic Association Test}
\usage{
BAT(y, G, X = NULL, parallel = F)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Obs by snp genotype matrix.}

\item{X}{Model matrix of covariates and structure adjustments. Should include
an intercept. Omit to perform marginal tests of association.}

\item{parallel}{Logical indicating whether to run in parallel. Must register
parallel backend first.}
}
\value{
A numeric matrix of score statistics and p-values, one for each locus
  (column) in \code{G}, assessing the null hypothesis of no genetic effect.
}
\description{
Conducts tests of association between the loci in \code{G} and the
untransformed phenotype \code{y}, adjusting for the model matrix \code{X}.
}
\examples{
\dontrun{
set.seed(100);
# Design matrix
X = cbind(1,rnorm(1e3));
# Genotypes
G = replicate(1e3,rbinom(n=1e3,size=2,prob=0.25));
storage.mode(G) = "numeric";
# Phenotype
y = as.numeric(X\%*\%c(1,1))+rnorm(1e3);
# Association test
p = BAT(y=y,G=G,X=X);
}
}
