% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMark-package.R
\docType{data}
\name{Paradise_shelduck}
\alias{Paradise_shelduck}
\alias{ps}
\title{Mulstistate Live-Dead Paradise Shelduck Data}
\format{A data frame with 1704 observations of 3 variables 
 \describe{ 
 \item{ch}{a character vector containing the capture history (each is 2 character positions LD) for 6 occasions}
 \item{freq}{capture history frequency} 
 \item{sex}{Male or Female}
 }}
\description{
Paradise shelduck recapture and recovery data in multistrata provided by Richard Barker and Gary White.
}
\examples{
\donttest{
# In the referenced article, there are 3 observable strata (A,B,C) and 
# 3 unobservable strata (D,E,F). This example is setup by default to use only  
# the 3 observable strata to avoid problems with multiple modes in the likelihood.  
# Code that uses all 6 strata are provided but commented out. With unobservable strata,
# simulated annealing should be used (options="SIMANNEAL")
data("Paradise_shelduck")
# change sex reference level to Male to match design matrix used in MARK
ps$sex=relevel(ps$sex,"Male")
# Process data with MSLiveDead model using sex groups and specify only observable strata
ps_dp=process.data(ps,model="MSLiveDead",groups="sex",strata.labels=c("A","B","C"))
# Process data with MSLiveDead model using sex groups and
# specify observable and unboservable strata
# ps_dp=process.data(ps,model="MSLiveDead",groups="sex",
#                        strata.labels=c("A","B","C","D","E","F"))
# Make design data and specify constant PIM for Psi to reduce parameter space. No time variation
# allowed in Psi in the article.
ddl=make.design.data(ps_dp,parameters=list(Psi=list(pim.type="constant")))
# Fix p to 0 for unobservable strata (only needed if they are included)
ddl$p$fix=NA
ddl$p$fix[ddl$p$stratum\%in\%c("D","E","F")]=0
# Fix p to 0 for last occasion
ddl$p$fix[ddl$p$time==6]=0.0
# Fix survival to 0.5 for last interval to match MARK file (to avoid confounding)
ddl$S$fix=NA
ddl$S$fix[ddl$S$time==6]=0.5
# create site variable for survival which matches A with D, B with E and C with F 
ddl$S$site="A"
ddl$S$site[ddl$S$stratum\%in\%c("B","C")]=as.character(ddl$S$stratum[ddl$S$stratum\%in\%c("B","C")])
ddl$S$site[ddl$S$stratum\%in\%c("E")]="B"
ddl$S$site[ddl$S$stratum\%in\%c("F")]="C"
ddl$S$site=as.factor(ddl$S$site)
# create same site variable for recovery probability (r)
ddl$r$site="A"
ddl$r$site[ddl$r$stratum\%in\%c("B","C")]=as.character(ddl$r$stratum[ddl$r$stratum\%in\%c("B","C")])
ddl$r$site[ddl$r$stratum\%in\%c("E")]="B"
ddl$r$site[ddl$r$stratum\%in\%c("F")]="C"
ddl$r$site=as.factor(ddl$r$site)
# Specify formula used in MARK model
S.1=list(formula=~-1+sex+time+site)
p.1=list(formula=~-1+stratum:time)
r.1=list(formula=~-1+time+sex+site)
Psi.1=list(formula=~-1+stratum:tostratum)
# Run top model from paper but only for observable strata
top_model=mark(ps_dp,ddl,model.parameters=list(S=S.1,p=p.1,r=r.1,Psi=Psi.1))
# Run top model from paper for all strata using simulated annealing (commented out)
#top_model=mark(ps_dp,ddl,model.parameters=list(S=S.1,p=p.1,r=r.1,Psi=Psi.1),
#      options="SIMANNEAL")
}
}
\references{
Barker, R.J, White,G.C, and M. McDougall. 2005. MOVEMENT OF PARADISE SHELDUCK BETWEEN MOLT SITES: 
A JOINT MULTISTATE-DEAD RECOVERY MARK–RECAPTURE MODEL. JOURNAL OF WILDLIFE MANAGEMENT 69(3):1194–1201.
}
\author{
Jeff Laake
}
\keyword{datasets}
