% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C.convert.R
\name{C.convert}
\alias{C.convert}
\title{Converts Cost from DALMKL to SEMKL or SimpleMKL}
\usage{
C.convert(K.train, DALMKL.model, C.DALMKL)
}
\arguments{
\item{K.train}{Gramm matrix of training data}

\item{DALMKL.model}{DAL MKL model}

\item{C.DALMKL}{Cost used in DAMKL model}
}
\value{
C cost SEMKL or SimpleMKL
}
\description{
This function estimates an a comparable cost for SEMKL or SimpleMKL  from DALMKL.
}
\examples{
data(benchmark.data)
data.mkl=benchmark.data[[1]]
kernels=rep('radial',2)
sigma=c(2,1/20)
train.samples=sample(1:nrow(data.mkl),floor(0.7*nrow(data.mkl)),replace=FALSE)
degree=sapply(1:length(kernels), function(a) ifelse(kernels[a]=='p',2,0))
#Kernels.gen splts the data into a training and test set, and generates the desired kernel matrices.
#Here we generate two gaussisan kernel matrices with sigma hyperparameter 2 and 0.05
K=kernels.gen(data=data.mkl[,1:2],train.samples=train.samples,kernels=kernels,sigma=sigma,
degree=degree,scale=rep(0,length(kernels)))
C=0.05 #Cost parameter for DALMKL
K.train=K$K.train
K.test=K$K.test

# parameters set up
ytr=data.mkl[train.samples,3]
#Converts list of kernel matrices in to an array with is appropriate for C++ code
k.train=simplify2array(K.train) 
k.test=simplify2array(K.test)
 #Implement DALMKL with the hinge loss function
 spicy_svmb1n=SpicyMKL(K=k.train,y=ytr, loss='hinge',C=C)
 #Convert cost from DALMKL to be more compatible withSimpleMKL
 C.SimpleMKL=C.convert(K.train,spicy_svmb1n,C)
}
