% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_significance_level.R
\name{adjust_significance_level}
\alias{adjust_significance_level}
\title{Adjust Significance Level on a Simulation Basis}
\usage{
adjust_significance_level(
  allocation_rule,
  models,
  N_total,
  N_ini,
  N_block,
  outcome_type = c("continuous", "binary"),
  sd_normal = NULL,
  alpha = 0.025,
  n_sim = 10000L,
  seed = NULL
)
}
\arguments{
\item{allocation_rule}{An object of class \link[RLoptimal]{AllocationRule}
specifying an obtained optimal adaptive allocation rule.}

\item{models}{An object of class \link[DoseFinding]{Mods} specifying assumed
dose-response models. This is used in the MCPMod method at the end of
this study.}

\item{N_total}{A positive integer value. The total number of subjects.}

\item{N_ini}{A positive integer vector in which each element is greater than
or equal to 2. The number of subjects initially assigned to each dose.}

\item{N_block}{A positive integer value. The number of subjects allocated
adaptively in each round.}

\item{outcome_type}{A character value specifying the outcome type.
Possible values are "continuous" (default), and "binary".}

\item{sd_normal}{A positive numeric value. The standard deviation of the
observation noise. When \code{outcome_type} is "continuous",
\code{sd_normal} must be specified.}

\item{alpha}{A positive numeric value. The original significance level.
Default is 0.025.}

\item{n_sim}{A positive integer value. The number of simulation studies
to calculate the adjusted significance level. Default is 10000.}

\item{seed}{An integer value. Random seed for data generation in the simulation
studies.}
}
\value{
A positive numeric value specifying adjusted significance level.
}
\description{
Adjust Significance Level on a Simulation Basis
}
\examples{
library(RLoptimal)

doses <- c(0, 2, 4, 6, 8)

models <- DoseFinding::Mods(
  doses = doses, maxEff = 1.65,
  linear = NULL, emax = 0.79, sigEmax = c(4, 5)
)

\dontrun{
allocation_rule <- learn_allocation_rule(
  models,
  N_total = 150, N_ini = rep(10, 5), N_block = 10, Delta = 1.3,
  outcome_type = "continuous", sd_normal = sqrt(4.5), 
  seed = 123, rl_config = rl_config_set(iter = 1000),
  alpha = 0.025
)

# Simulation-based adjustment of the significance level using `allocation_rule`
adjusted_alpha <- adjust_significance_level(
  allocation_rule, models,
  N_total = 150, N_ini = rep(10, 5), N_block = 10,
  outcome_type = "continuous", sd_normal = sqrt(4.5),
  alpha = 0.025, n_sim = 10000, seed = 123
)}

}
