/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.AttributeEvaluator;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class ReliefFAttributeEval
extends AttributeEvaluator
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -8422186665795839379L;
    private Instances m_trainInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private boolean m_numericClass;
    private int m_numClasses;
    private double m_ndc;
    private double[] m_nda;
    private double[] m_ndcda;
    private double[] m_weights;
    private double[] m_classProbs;
    private int m_sampleM;
    private int m_Knn;
    private double[][][] m_karray;
    private double[] m_maxArray;
    private double[] m_minArray;
    private double[] m_worst;
    private int[] m_index;
    private int[] m_stored;
    private int m_seed;
    private double[] m_weightsByRank;
    private int m_sigma;
    private boolean m_weightByDistance;

    public ReliefFAttributeEval() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "ReliefFAttributeEval :\n\nEvaluates the worth of an attribute by repeatedly sampling an instance and considering the value of the given attribute for the nearest instance of the same and different class. Can operate on both discrete and continuous class data.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Kenji Kira and Larry A. Rendell");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "A Practical Approach to Feature Selection");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Ninth International Workshop on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.EDITOR, "Derek H. Sleeman and Peter Edwards");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1992");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "249-256");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Igor Kononenko");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Estimating Attributes: Analysis and Extensions of RELIEF");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "European Conference on Machine Learning");
        technicalInformation2.setValue(TechnicalInformation.Field.EDITOR, "Francesco Bergadano and Luc De Raedt");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "1994");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "171-182");
        technicalInformation2.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Marko Robnik-Sikonja and Igor Kononenko");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "An adaptation of Relief for attribute estimation in regression");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "Fourteenth International Conference on Machine Learning");
        technicalInformation2.setValue(TechnicalInformation.Field.EDITOR, "Douglas H. Fisher");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "1997");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "296-304");
        technicalInformation2.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tSpecify the number of instances to\n\tsample when estimating attributes.\n\tIf not specified, then all instances\n\twill be used.", "M", 1, "-M <num instances>"));
        vector.addElement(new Option("\tSeed for randomly sampling instances.\n\t(Default = 1)", "D", 1, "-D <seed>"));
        vector.addElement(new Option("\tNumber of nearest neighbours (k) used\n\tto estimate attribute relevances\n\t(Default = 10).", "K", 1, "-K <number of neighbours>"));
        vector.addElement(new Option("\tWeight nearest neighbours by distance\n", "W", 0, "-W"));
        vector.addElement(new Option("\tSpecify sigma value (used in an exp\n\tfunction to control how quickly\n\tweights for more distant instances\n\tdecrease. Use in conjunction with -W.\n\tSensible value=1/5 to 1/10 of the\n\tnumber of nearest neighbours.\n\t(Default = 2)", "A", 1, "-A <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        this.setWeightByDistance(Utils.getFlag('W', stringArray));
        String string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setSampleSize(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('D', stringArray)).length() != 0) {
            this.setSeed(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('K', stringArray)).length() != 0) {
            this.setNumNeighbours(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('A', stringArray)).length() != 0) {
            this.setWeightByDistance(true);
            this.setSigma(Integer.parseInt(string));
        }
    }

    public String sigmaTipText() {
        return "Set influence of nearest neighbours. Used in an exp function to control how quickly weights decrease for more distant instances. Use in conjunction with weightByDistance. Sensible values = 1/5 to 1/10 the number of nearest neighbours.";
    }

    public void setSigma(int n) throws Exception {
        if (n <= 0) {
            throw new Exception("value of sigma must be > 0!");
        }
        this.m_sigma = n;
    }

    public int getSigma() {
        return this.m_sigma;
    }

    public String numNeighboursTipText() {
        return "Number of nearest neighbours for attribute estimation.";
    }

    public void setNumNeighbours(int n) {
        this.m_Knn = n;
    }

    public int getNumNeighbours() {
        return this.m_Knn;
    }

    public String seedTipText() {
        return "Random seed for sampling instances.";
    }

    public void setSeed(int n) {
        this.m_seed = n;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public String sampleSizeTipText() {
        return "Number of instances to sample. Default (-1) indicates that all instances will be used for attribute estimation.";
    }

    public void setSampleSize(int n) {
        this.m_sampleM = n;
    }

    public int getSampleSize() {
        return this.m_sampleM;
    }

    public String weightByDistanceTipText() {
        return "Weight nearest neighbours by their distance.";
    }

    public void setWeightByDistance(boolean bl) {
        this.m_weightByDistance = bl;
    }

    public boolean getWeightByDistance() {
        return this.m_weightByDistance;
    }

    public String[] getOptions() {
        String[] stringArray = new String[9];
        int n = 0;
        if (this.getWeightByDistance()) {
            stringArray[n++] = "-W";
        }
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getSampleSize();
        stringArray[n++] = "-D";
        stringArray[n++] = "" + this.getSeed();
        stringArray[n++] = "-K";
        stringArray[n++] = "" + this.getNumNeighbours();
        if (this.getWeightByDistance()) {
            stringArray[n++] = "-A";
            stringArray[n++] = "" + this.getSigma();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_trainInstances == null) {
            stringBuffer.append("ReliefF feature evaluator has not been built yet\n");
        } else {
            stringBuffer.append("\tReliefF Ranking Filter");
            stringBuffer.append("\n\tInstances sampled: ");
            if (this.m_sampleM == -1) {
                stringBuffer.append("all\n");
            } else {
                stringBuffer.append(this.m_sampleM + "\n");
            }
            stringBuffer.append("\tNumber of nearest neighbours (k): " + this.m_Knn + "\n");
            if (this.m_weightByDistance) {
                stringBuffer.append("\tExponentially decreasing (with distance) influence for\n\tnearest neighbours. Sigma: " + this.m_sigma + "\n");
            } else {
                stringBuffer.append("\tEqual influence nearest neighbours\n");
            }
        }
        return stringBuffer.toString();
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        int n;
        Random random = new Random(this.m_seed);
        this.getCapabilities().testWithFail(instances);
        this.m_trainInstances = instances;
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.m_numInstances = this.m_trainInstances.numInstances();
        this.m_numericClass = this.m_trainInstances.attribute(this.m_classIndex).isNumeric();
        if (!this.m_numericClass) {
            this.m_numClasses = this.m_trainInstances.attribute(this.m_classIndex).numValues();
        } else {
            this.m_ndc = 0.0;
            this.m_numClasses = 1;
            this.m_nda = new double[this.m_numAttribs];
            this.m_ndcda = new double[this.m_numAttribs];
        }
        if (this.m_weightByDistance) {
            this.m_weightsByRank = new double[this.m_Knn];
            for (n = 0; n < this.m_Knn; ++n) {
                this.m_weightsByRank[n] = Math.exp(-((double)n / (double)this.m_sigma * ((double)n / (double)this.m_sigma)));
            }
        }
        this.m_weights = new double[this.m_numAttribs];
        this.m_karray = new double[this.m_numClasses][this.m_Knn][2];
        if (!this.m_numericClass) {
            this.m_classProbs = new double[this.m_numClasses];
            for (n = 0; n < this.m_numInstances; ++n) {
                int n2 = (int)this.m_trainInstances.instance(n).value(this.m_classIndex);
                this.m_classProbs[n2] = this.m_classProbs[n2] + 1.0;
            }
            n = 0;
            while (n < this.m_numClasses) {
                int n3 = n++;
                this.m_classProbs[n3] = this.m_classProbs[n3] / (double)this.m_numInstances;
            }
        }
        this.m_worst = new double[this.m_numClasses];
        this.m_index = new int[this.m_numClasses];
        this.m_stored = new int[this.m_numClasses];
        this.m_minArray = new double[this.m_numAttribs];
        this.m_maxArray = new double[this.m_numAttribs];
        for (n = 0; n < this.m_numAttribs; ++n) {
            this.m_maxArray[n] = Double.NaN;
            this.m_minArray[n] = Double.NaN;
        }
        for (n = 0; n < this.m_numInstances; ++n) {
            this.updateMinMax(this.m_trainInstances.instance(n));
        }
        int n4 = this.m_sampleM > this.m_numInstances || this.m_sampleM < 0 ? this.m_numInstances : this.m_sampleM;
        for (n = 0; n < n4; ++n) {
            int n5 = n4 == this.m_numInstances ? n : random.nextInt() % this.m_numInstances;
            if (n5 < 0) {
                n5 *= -1;
            }
            if (this.m_trainInstances.instance(n5).isMissing(this.m_classIndex)) continue;
            for (int i = 0; i < this.m_numClasses; ++i) {
                this.m_stored[i] = 0;
                this.m_index[i] = 0;
                for (int j = 0; j < this.m_Knn; ++j) {
                    this.m_karray[i][j][1] = 0.0;
                    this.m_karray[i][j][0] = 0.0;
                }
            }
            this.findKHitMiss(n5);
            if (this.m_numericClass) {
                this.updateWeightsNumericClass(n5);
                continue;
            }
            this.updateWeightsDiscreteClass(n5);
        }
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (n == this.m_classIndex) continue;
            if (this.m_numericClass) {
                this.m_weights[n] = this.m_ndcda[n] / this.m_ndc - (this.m_nda[n] - this.m_ndcda[n]) / ((double)n4 - this.m_ndc);
                continue;
            }
            int n6 = n;
            this.m_weights[n6] = this.m_weights[n6] * (1.0 / (double)n4);
        }
    }

    public double evaluateAttribute(int n) throws Exception {
        return this.m_weights[n];
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_sampleM = -1;
        this.m_Knn = 10;
        this.m_sigma = 2;
        this.m_weightByDistance = false;
        this.m_seed = 1;
    }

    private double norm(double d, int n) {
        if (Double.isNaN(this.m_minArray[n]) || Utils.eq(this.m_maxArray[n], this.m_minArray[n])) {
            return 0.0;
        }
        return (d - this.m_minArray[n]) / (this.m_maxArray[n] - this.m_minArray[n]);
    }

    private void updateMinMax(Instance instance) {
        try {
            for (int i = 0; i < instance.numValues(); ++i) {
                if (!instance.attributeSparse(i).isNumeric() || instance.isMissingSparse(i)) continue;
                if (Double.isNaN(this.m_minArray[instance.index(i)])) {
                    this.m_minArray[instance.index((int)i)] = instance.valueSparse(i);
                    this.m_maxArray[instance.index((int)i)] = instance.valueSparse(i);
                    continue;
                }
                if (instance.valueSparse(i) < this.m_minArray[instance.index(i)]) {
                    this.m_minArray[instance.index((int)i)] = instance.valueSparse(i);
                    continue;
                }
                if (!(instance.valueSparse(i) > this.m_maxArray[instance.index(i)])) continue;
                this.m_maxArray[instance.index((int)i)] = instance.valueSparse(i);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    private double difference(int n, double d, double d2) {
        switch (this.m_trainInstances.attribute(n).type()) {
            case 1: {
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2)) {
                    return 1.0 - 1.0 / (double)this.m_trainInstances.attribute(n).numValues();
                }
                if ((int)d != (int)d2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 0: {
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2)) {
                    if (Instance.isMissingValue(d) && Instance.isMissingValue(d2)) {
                        return 1.0;
                    }
                    double d3 = Instance.isMissingValue(d2) ? this.norm(d, n) : this.norm(d2, n);
                    if (d3 < 0.5) {
                        d3 = 1.0 - d3;
                    }
                    return d3;
                }
                return Math.abs(this.norm(d, n) - this.norm(d2, n));
            }
        }
        return 0.0;
    }

    private double distance(Instance instance, Instance instance2) {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n < instance.numValues() || n2 < instance2.numValues()) {
            double d2;
            int n3 = n >= instance.numValues() ? this.m_trainInstances.numAttributes() : instance.index(n);
            int n4 = n2 >= instance2.numValues() ? this.m_trainInstances.numAttributes() : instance2.index(n2);
            if (n3 == this.m_trainInstances.classIndex()) {
                ++n;
                continue;
            }
            if (n4 == this.m_trainInstances.classIndex()) {
                ++n2;
                continue;
            }
            if (n3 == n4) {
                d2 = this.difference(n3, instance.valueSparse(n), instance2.valueSparse(n2));
                ++n;
                ++n2;
            } else if (n3 > n4) {
                d2 = this.difference(n4, 0.0, instance2.valueSparse(n2));
                ++n2;
            } else {
                d2 = this.difference(n3, instance.valueSparse(n), 0.0);
                ++n;
            }
            d += d2;
        }
        return d;
    }

    private void updateWeightsNumericClass(int n) {
        int n2;
        int[] nArray = null;
        double[] dArray = null;
        double d = 1.0;
        Instance instance = this.m_trainInstances.instance(n);
        if (this.m_weightByDistance) {
            dArray = new double[this.m_stored[0]];
            d = 0.0;
            for (n2 = 0; n2 < this.m_stored[0]; ++n2) {
                dArray[n2] = this.m_karray[0][n2][0];
                d += this.m_weightsByRank[n2];
            }
            nArray = Utils.sort(dArray);
        }
        for (int i = 0; i < this.m_stored[0]; ++i) {
            double d2;
            if (this.m_weightByDistance) {
                d2 = this.difference(this.m_classIndex, instance.value(this.m_classIndex), this.m_trainInstances.instance((int)this.m_karray[0][nArray[i]][1]).value(this.m_classIndex));
                d2 *= this.m_weightsByRank[i] / d;
            } else {
                d2 = this.difference(this.m_classIndex, instance.value(this.m_classIndex), this.m_trainInstances.instance((int)this.m_karray[0][i][1]).value(this.m_classIndex));
                d2 *= 1.0 / (double)this.m_stored[0];
            }
            this.m_ndc += d2;
            Instance instance2 = this.m_weightByDistance ? this.m_trainInstances.instance((int)this.m_karray[0][nArray[i]][1]) : this.m_trainInstances.instance((int)this.m_karray[0][i][1]);
            double d3 = this.difference(this.m_classIndex, instance.value(this.m_classIndex), instance2.value(this.m_classIndex));
            int n3 = 0;
            int n4 = 0;
            while (n3 < instance.numValues() || n4 < instance2.numValues()) {
                int n5 = n3 >= instance.numValues() ? this.m_trainInstances.numAttributes() : instance.index(n3);
                int n6 = n4 >= instance2.numValues() ? this.m_trainInstances.numAttributes() : instance2.index(n4);
                if (n5 == this.m_trainInstances.classIndex()) {
                    ++n3;
                    continue;
                }
                if (n6 == this.m_trainInstances.classIndex()) {
                    ++n4;
                    continue;
                }
                d2 = 0.0;
                double d4 = 0.0;
                if (n5 == n6) {
                    n2 = n5;
                    d2 = this.difference(n2, instance.valueSparse(n3), instance2.valueSparse(n4));
                    ++n3;
                    ++n4;
                } else if (n5 > n6) {
                    n2 = n6;
                    d2 = this.difference(n2, 0.0, instance2.valueSparse(n4));
                    ++n4;
                } else {
                    n2 = n5;
                    d2 = this.difference(n2, instance.valueSparse(n3), 0.0);
                    ++n3;
                }
                d4 = d3 * d2;
                d4 = this.m_weightByDistance ? (d4 *= this.m_weightsByRank[i] / d) : (d4 *= 1.0 / (double)this.m_stored[0]);
                int n7 = n2;
                this.m_ndcda[n7] = this.m_ndcda[n7] + d4;
                d2 = this.m_weightByDistance ? (d2 *= this.m_weightsByRank[i] / d) : (d2 *= 1.0 / (double)this.m_stored[0]);
                int n8 = n2;
                this.m_nda[n8] = this.m_nda[n8] + d2;
            }
        }
    }

    private void updateWeightsDiscreteClass(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Instance instance;
        int n7;
        int n8;
        double d = 1.0;
        int[] nArray = null;
        double d2 = 1.0;
        int[][] nArray2 = null;
        double[] dArray = null;
        Instance instance2 = this.m_trainInstances.instance(n);
        int n9 = (int)this.m_trainInstances.instance(n).value(this.m_classIndex);
        if (this.m_weightByDistance) {
            double[] dArray2 = new double[this.m_stored[n9]];
            d2 = 0.0;
            for (n8 = 0; n8 < this.m_stored[n9]; ++n8) {
                dArray2[n8] = this.m_karray[n9][n8][0];
                d2 += this.m_weightsByRank[n8];
            }
            nArray = Utils.sort(dArray2);
            nArray2 = new int[this.m_numClasses][1];
            dArray = new double[this.m_numClasses];
            for (n7 = 0; n7 < this.m_numClasses; ++n7) {
                if (n7 == n9) continue;
                double[] dArray3 = new double[this.m_stored[n7]];
                dArray[n7] = 0.0;
                for (n8 = 0; n8 < this.m_stored[n7]; ++n8) {
                    dArray3[n8] = this.m_karray[n7][n8][0];
                    int n10 = n7;
                    dArray[n10] = dArray[n10] + this.m_weightsByRank[n8];
                }
                nArray2[n7] = Utils.sort(dArray3);
            }
        }
        if (this.m_numClasses > 2) {
            d = 1.0 - this.m_classProbs[n9];
        }
        double d3 = 0.0;
        for (n8 = 0; n8 < this.m_stored[n9]; ++n8) {
            instance = this.m_weightByDistance ? this.m_trainInstances.instance((int)this.m_karray[n9][nArray[n8]][1]) : this.m_trainInstances.instance((int)this.m_karray[n9][n8][1]);
            n6 = 0;
            n5 = 0;
            while (n6 < instance2.numValues() || n5 < instance.numValues()) {
                n4 = n6 >= instance2.numValues() ? this.m_trainInstances.numAttributes() : instance2.index(n6);
                n3 = n5 >= instance.numValues() ? this.m_trainInstances.numAttributes() : instance.index(n5);
                if (n4 == this.m_trainInstances.classIndex()) {
                    ++n6;
                    continue;
                }
                if (n3 == this.m_trainInstances.classIndex()) {
                    ++n5;
                    continue;
                }
                if (n4 == n3) {
                    n2 = n4;
                    d3 = this.difference(n2, instance2.valueSparse(n6), instance.valueSparse(n5));
                    ++n6;
                    ++n5;
                } else if (n4 > n3) {
                    n2 = n3;
                    d3 = this.difference(n2, 0.0, instance.valueSparse(n5));
                    ++n5;
                } else {
                    n2 = n4;
                    d3 = this.difference(n2, instance2.valueSparse(n6), 0.0);
                    ++n6;
                }
                if (this.m_weightByDistance) {
                    d3 *= this.m_weightsByRank[n8] / d2;
                } else if (this.m_stored[n9] > 0) {
                    d3 /= (double)this.m_stored[n9];
                }
                int n11 = n2;
                this.m_weights[n11] = this.m_weights[n11] - d3;
            }
        }
        d3 = 0.0;
        for (n7 = 0; n7 < this.m_numClasses; ++n7) {
            if (n7 == n9) continue;
            for (n8 = 0; n8 < this.m_stored[n7]; ++n8) {
                instance = this.m_weightByDistance ? this.m_trainInstances.instance((int)this.m_karray[n7][nArray2[n7][n8]][1]) : this.m_trainInstances.instance((int)this.m_karray[n7][n8][1]);
                n6 = 0;
                n5 = 0;
                while (n6 < instance2.numValues() || n5 < instance.numValues()) {
                    n4 = n6 >= instance2.numValues() ? this.m_trainInstances.numAttributes() : instance2.index(n6);
                    n3 = n5 >= instance.numValues() ? this.m_trainInstances.numAttributes() : instance.index(n5);
                    if (n4 == this.m_trainInstances.classIndex()) {
                        ++n6;
                        continue;
                    }
                    if (n3 == this.m_trainInstances.classIndex()) {
                        ++n5;
                        continue;
                    }
                    if (n4 == n3) {
                        n2 = n4;
                        d3 = this.difference(n2, instance2.valueSparse(n6), instance.valueSparse(n5));
                        ++n6;
                        ++n5;
                    } else if (n4 > n3) {
                        n2 = n3;
                        d3 = this.difference(n2, 0.0, instance.valueSparse(n5));
                        ++n5;
                    } else {
                        n2 = n4;
                        d3 = this.difference(n2, instance2.valueSparse(n6), 0.0);
                        ++n6;
                    }
                    if (this.m_weightByDistance) {
                        d3 *= this.m_weightsByRank[n8] / dArray[n7];
                    } else if (this.m_stored[n7] > 0) {
                        d3 /= (double)this.m_stored[n7];
                    }
                    if (this.m_numClasses > 2) {
                        int n12 = n2;
                        this.m_weights[n12] = this.m_weights[n12] + this.m_classProbs[n7] / d * d3;
                        continue;
                    }
                    int n13 = n2;
                    this.m_weights[n13] = this.m_weights[n13] + d3;
                }
            }
        }
    }

    private void findKHitMiss(int n) {
        double d = 0.0;
        Instance instance = this.m_trainInstances.instance(n);
        for (int i = 0; i < this.m_numInstances; ++i) {
            int n2;
            double d2;
            if (i == n) continue;
            Instance instance2 = this.m_trainInstances.instance(i);
            d = this.distance(instance2, instance);
            int n3 = this.m_numericClass ? 0 : (int)this.m_trainInstances.instance(i).value(this.m_classIndex);
            if (this.m_stored[n3] < this.m_Knn) {
                this.m_karray[n3][this.m_stored[n3]][0] = d;
                this.m_karray[n3][this.m_stored[n3]][1] = i;
                int n4 = n3;
                this.m_stored[n4] = this.m_stored[n4] + 1;
                d2 = -1.0;
                for (n2 = 0; n2 < this.m_stored[n3]; ++n2) {
                    if (!(this.m_karray[n3][n2][0] > d2)) continue;
                    d2 = this.m_karray[n3][n2][0];
                    this.m_index[n3] = n2;
                }
                this.m_worst[n3] = d2;
                continue;
            }
            if (!(d < this.m_karray[n3][this.m_index[n3]][0])) continue;
            this.m_karray[n3][this.m_index[n3]][0] = d;
            this.m_karray[n3][this.m_index[n3]][1] = i;
            d2 = -1.0;
            for (n2 = 0; n2 < this.m_stored[n3]; ++n2) {
                if (!(this.m_karray[n3][n2][0] > d2)) continue;
                d2 = this.m_karray[n3][n2][0];
                this.m_index[n3] = n2;
            }
            this.m_worst[n3] = d2;
        }
    }

    public static void main(String[] stringArray) {
        ReliefFAttributeEval.runEvaluator(new ReliefFAttributeEval(), stringArray);
    }
}

