% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SsPowerGivenJK.R
\name{SsPowerGivenJKDbmVarCom}
\alias{SsPowerGivenJKDbmVarCom}
\title{Power given J, K and Dorfman-Berbaum-Metz variance components}
\usage{
SsPowerGivenJKDbmVarCom(
  J,
  K,
  effectSize,
  VarTR,
  VarTC,
  VarErr,
  alpha = 0.05,
  analysisOption = "RRRC"
)
}
\arguments{
\item{J}{The number of readers}

\item{K}{The number of cases}

\item{effectSize}{The effect size}

\item{VarTR}{The treatment-reader DBM variance component}

\item{VarTC}{The treatment-case DBM variance component}

\item{VarErr}{The error-term DBM variance component}

\item{alpha}{The size of the test (default = 0.05)}

\item{analysisOption}{The desired generalization ("RRRC", "FRRC", "RRFC", "ALL")}
}
\value{
A list object containing the estimated power and associated statistics
   for each desired generalization.
}
\description{
Power given J, K and Dorfman-Berbaum-Metz variance components
}
\details{
The variance components are obtained using \link{StSignificanceTesting}
   with \code{method = "DBM"}.
}
\examples{
VarCom <- StSignificanceTesting(dataset02, FOM = "Wilcoxon", method = "DBM", 
   analysisOption = "RRRC")$ANOVA$VarCom
VarTR <- VarCom["VarTR",1]
VarTC <- VarCom["VarTC",1]
VarErr <- VarCom["VarErr",1]
ret <- SsPowerGivenJKDbmVarCom (J = 5, K = 100, effectSize = 0.05, VarTR, 
   VarTC, VarErr, analysisOption = "RRRC")
cat("RRRC power = ", ret$powerRRRC)
  
}
