/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.GenericSDMXClient;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.api.SDMXReference;
import it.bancaditalia.oss.sdmx.api.SDMXVersion;
import it.bancaditalia.oss.sdmx.client.Credentials;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.event.DataFooterMessageEvent;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.parser.v21.CodelistParser;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.parser.v21.DataStructureParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataflowParser;
import it.bancaditalia.oss.sdmx.parser.v30.AvailabilityParser;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.QueryRunner;
import it.bancaditalia.oss.sdmx.util.RestQueryBuilder;
import it.bancaditalia.oss.sdmx.util.Utils;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class AbstractRestSdmxClient<T extends RestQueryBuilder<T>>
implements GenericSDMXClient {
    protected static final Logger LOGGER = Configuration.getSdmxLogger();
    private final SDMXVersion sdmxVersion;
    private final Credentials credentials = new Credentials();
    private final Provider provider;
    private final String latestKeyword;
    private final String allKeyword;
    protected boolean needsCredentials = false;

    public AbstractRestSdmxClient(Provider provider, SDMXVersion sDMXVersion) {
        this.provider = provider;
        this.needsCredentials = provider.isNeedsCredentials();
        this.sdmxVersion = sDMXVersion;
        if (sDMXVersion == SDMXVersion.V3) {
            this.latestKeyword = "+";
            this.allKeyword = "*";
        } else {
            this.latestKeyword = "latest";
            this.allKeyword = "all";
        }
    }

    public Provider getProvider() {
        return this.provider;
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        HashMap<String, Dataflow> hashMap = null;
        URL uRL = this.buildFlowQuery(this.allKeyword, this.allKeyword, this.latestKeyword);
        List<Dataflow> list = QueryRunner.runQuery(new DataflowParser(), uRL, "dataflow_all", this.getName(), this.handleHttpHeaders("application/vnd.sdmx.structure+xml;version=2.1"));
        if (list.size() > 0) {
            hashMap = new HashMap<String, Dataflow>();
            for (Dataflow dataflow : list) {
                hashMap.put(dataflow.getFullIdentifier(), dataflow);
            }
        } else {
            throw new SdmxXmlContentException("The query returned zero dataflows");
        }
        return hashMap;
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        URL uRL;
        List<Dataflow> list;
        Dataflow dataflow = null;
        if (string2 == null) {
            string2 = this.allKeyword;
        }
        if (string3 == null) {
            string3 = this.latestKeyword;
        }
        if ((list = QueryRunner.runQuery(new DataflowParser(), uRL = this.buildFlowQuery(string, string2, string3), this.getName(), "dataflow_" + string, this.handleHttpHeaders("application/vnd.sdmx.structure+xml;version=2.1"))).size() < 1) {
            throw new SdmxXmlContentException("The query returned zero dataflows");
        }
        dataflow = list.get(0);
        return dataflow;
    }

    @Override
    public DataFlowStructure getDataFlowStructure(SDMXReference sDMXReference, boolean bl) throws SdmxException {
        if (sDMXReference == null) {
            throw new SdmxInvalidParameterException("getDataFlowStructure(): Null dsd in input");
        }
        URL uRL = this.buildDSDQuery(sDMXReference.getId(), sDMXReference.getAgency(), sDMXReference.getVersion(), bl);
        return QueryRunner.runQuery(new DataStructureParser(), uRL, this.getName(), "datastructure_" + sDMXReference.getId(), this.handleHttpHeaders("application/vnd.sdmx.structure+xml;version=2.1")).get(0);
    }

    @Override
    public Codelist getCodes(String string, String string2, String string3) throws SdmxException {
        URL uRL = this.buildCodelistQuery(string, string2, string3);
        return QueryRunner.runQuery(new CodelistParser(), uRL, this.getName(), "codelist_" + string, this.handleHttpHeaders("application/vnd.sdmx.structure+xml;version=2.1"));
    }

    @Override
    public List<PortableTimeSeries<Double>> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        return this.postProcess(this.getData(dataflow, dataFlowStructure, string, string2, string3, bl, string4, bl2));
    }

    @Override
    public List<PortableTimeSeries<Double>> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws SdmxException {
        throw new SdmxInvalidParameterException("This method can only be called on SDMX V3 providers.");
    }

    @Override
    public Map<String, List<String>> getAvailableCubeRegion(Dataflow dataflow, String string, String string2) throws SdmxException {
        URL uRL = this.buildAvailabilityQueryByKey(dataflow, string);
        return QueryRunner.runQuery(new AvailabilityParser(), uRL, this.handleHttpHeaders("application/vnd.sdmx.structure+xml;version=2.1"));
    }

    @Override
    public Map<String, Integer> getAvailableTimeSeriesNumber(Dataflow dataflow, String string) throws SdmxException {
        throw new SdmxInvalidParameterException("This method can only be called on SDMX V3 providers.");
    }

    protected DataParsingResult getData(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        URL uRL = this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2, null);
        String string5 = "data_" + dataflow.getId() + "_" + string;
        DataParsingResult dataParsingResult = QueryRunner.runQuery(new CompactDataParser(dataFlowStructure, dataflow, !bl, bl2), uRL, this.getName(), string5, this.handleHttpHeaders("application/vnd.sdmx.structurespecificdata+xml;version=2.1"));
        Message message = dataParsingResult.getMessage();
        if (message != null) {
            LOGGER.log(Level.INFO, "The sdmx call returned messages in the footer:\n {0}", message);
            DataFooterMessageEvent dataFooterMessageEvent = new DataFooterMessageEvent(uRL, message);
            QueryRunner.getDataFooterMessageEventListener().onSdmxEvent(dataFooterMessageEvent);
        }
        return dataParsingResult;
    }

    @Override
    public boolean needsCredentials() {
        return this.needsCredentials;
    }

    @Override
    public void setCredentials(String string, String string2) {
        this.needsCredentials = false;
        this.credentials.fillCredentials(string, string2);
    }

    @Override
    public String getName() {
        return this.getProvider().getName();
    }

    public String getSdmxVersion() {
        return this.sdmxVersion.toString();
    }

    @Override
    public final String buildDataURL(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        return this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2, null).toString();
    }

    protected URL buildAvailabilityQueryByKey(Dataflow dataflow, String string) throws SdmxException {
        if (dataflow != null) {
            return ((RestQueryBuilder)((RestQueryBuilder)((RestQueryBuilder)((RestQueryBuilder)this.getBuilder()).addPath("availableconstraint")).addPath(dataflow.getId())).addPath(string)).build();
        }
        throw new SdmxInvalidParameterException("Invalid query parameters: dataflow=" + dataflow + " filter=" + string);
    }

    protected URL buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2, String string5) throws SdmxException {
        Utils.checkString(string, "The timeslot for an observation cannot be null or empty.");
        if (dataflow != null) {
            return ((RestQueryBuilder)((RestQueryBuilder)((RestQueryBuilder)((RestQueryBuilder)((RestQueryBuilder)((RestQueryBuilder)((RestQueryBuilder)((RestQueryBuilder)((RestQueryBuilder)((RestQueryBuilder)this.getBuilder()).withParam("startPeriod", string2)).withParam("endPeriod", string3)).withDetail(bl)).withParam("updatedAfter", string4)).withHistory(bl2)).withParam("format", string5)).addPath("data")).addPath(dataflow.getFullIdentifier())).addPath(string)).build();
        }
        throw new SdmxInvalidParameterException("Invalid query parameters: dataflow=" + dataflow + " tsKey=" + string + " endpoint=" + this.getProvider().getEndpoint());
    }

    protected URL buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        Utils.checkString(string2, "The name of the agency cannot be null");
        Utils.checkString(string, "The name of the data structure cannot be null");
        if (string2 != null && !string2.isEmpty() && string != null && !string.isEmpty()) {
            Object t = ((RestQueryBuilder)((RestQueryBuilder)((RestQueryBuilder)this.getBuilder()).addPath("datastructure")).addPath(string2)).addPath(string);
            if (string3 != null && !string3.isEmpty()) {
                t = ((RestQueryBuilder)t).addPath(string3);
            }
            if (bl) {
                t = ((RestQueryBuilder)t).withParam("references", "descendants");
            }
            return ((RestQueryBuilder)t).build();
        }
        throw new RuntimeException("Invalid query parameters: agency=" + string2 + " dsd=" + string + " endpoint=" + this.getProvider().getEndpoint());
    }

    protected URL buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        return ((RestQueryBuilder)((RestQueryBuilder)((RestQueryBuilder)this.getBuilder()).addPath("dataflow")).withRef(string2, string, string3)).build();
    }

    protected URL buildCodelistQuery(String string, String string2, String string3) throws SdmxException {
        return ((RestQueryBuilder)((RestQueryBuilder)((RestQueryBuilder)this.getBuilder()).addPath("codelist")).withRef(string2, string, string3)).build();
    }

    protected List<PortableTimeSeries<Double>> postProcess(DataParsingResult dataParsingResult) {
        return dataParsingResult;
    }

    public Map<String, String> handleHttpHeaders(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = Configuration.getLanguages().stream().map(languageRange -> String.format(Locale.US, "%s;q=%.1f", languageRange.getRange(), languageRange.getWeight())).collect(Collectors.joining(","));
        hashMap.put("Accept-Language", string2);
        String string3 = this.credentials.getHeader();
        if (string3 != null) {
            LOGGER.fine("Setting http authorization");
            hashMap.put("Authorization", "Basic " + string3);
        }
        if (this.getProvider().isSupportsCompression()) {
            hashMap.put("Accept-Encoding", "gzip,deflate");
        }
        if (string != null && !"".equals(string)) {
            hashMap.put("Accept", string);
        } else {
            hashMap.put("Accept", "*/*");
        }
        hashMap.put("user-agent", "RJSDMX");
        return hashMap;
    }

    public String getLatestKeyword() {
        return this.latestKeyword;
    }

    public String getAllKeyword() {
        return this.allKeyword;
    }

    public T getBuilder() {
        return this.getBuilder(this.provider.getEndpoint());
    }

    protected abstract T getBuilder(URI var1);
}

