/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.api.SDMXVersion;
import it.bancaditalia.oss.sdmx.client.AbstractRestSdmxClient;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.event.DataFooterMessageEvent;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.parser.v30.AvailabilityParser;
import it.bancaditalia.oss.sdmx.parser.v30.SeriesCountParser;
import it.bancaditalia.oss.sdmx.util.QueryRunner;
import it.bancaditalia.oss.sdmx.util.RestQueryBuilder;
import it.bancaditalia.oss.sdmx.util.Utils;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class RestSdmx30Client
extends AbstractRestSdmxClient<Sdmx30Queries> {
    public RestSdmx30Client(Provider provider) {
        super(provider, SDMXVersion.V3);
    }

    @Override
    protected Sdmx30Queries getBuilder(URI uRI) {
        return new Sdmx30Queries(uRI);
    }

    @Override
    public List<PortableTimeSeries<Double>> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        return this.getTimeSeries(dataflow, dataFlowStructure, string, null, string2, string3, bl ? "none" : "all", bl ? "none" : "all", string4, bl2);
    }

    @Override
    public List<PortableTimeSeries<Double>> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws SdmxException {
        return this.postProcess(this.getData(dataflow, dataFlowStructure, string, string2, string3, string4, string5, string6, string7, bl));
    }

    @Override
    public Map<String, List<String>> getAvailableCubeRegion(Dataflow dataflow, String string, String string2) throws SdmxException {
        URL uRL = this.buildAvailabilityQuery(dataflow, string, string2);
        return QueryRunner.runQuery(new AvailabilityParser(), uRL, this.handleHttpHeaders("application/vnd.sdmx.structure+xml;version=2.1"));
    }

    @Override
    public Map<String, Integer> getAvailableTimeSeriesNumber(Dataflow dataflow, String string) throws SdmxException {
        URL uRL = this.buildAvailabilityQuery(dataflow, string, "exact");
        return QueryRunner.runQuery(new SeriesCountParser(), uRL, this.handleHttpHeaders("application/vnd.sdmx.structure+xml;version=2.1"));
    }

    protected DataParsingResult getData(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String object, String string2, String string3, String string4, String string5, String string6, boolean bl) throws SdmxException {
        Object object2;
        if (string != null && !string.isEmpty()) {
            if (string.contains("+")) {
                object2 = this.mapSDMX2KeytoSDMX3FIlter(string, dataFlowStructure);
                object = object != null && !((String)object).isEmpty() ? (String)object + "&" + (String)object2 : object2;
                string = null;
            } else {
                string = string.replace("..", ".*.").replace("..", ".*.");
            }
        }
        object2 = this.buildDataQuery(dataflow, string, (String)object, string2, string3, string4, string5, string6, bl);
        String string7 = "data_" + dataflow.getId() + "_" + (String)object;
        DataParsingResult dataParsingResult = QueryRunner.runQuery(new CompactDataParser(dataFlowStructure, dataflow, !"none".equals(string4) || !"none".equals(string5)), (URL)object2, this.getName(), string7, this.handleHttpHeaders("application/vnd.sdmx.structurespecificdata+xml;version=2.1"));
        Message message = dataParsingResult.getMessage();
        if (message != null) {
            LOGGER.log(Level.INFO, "The sdmx call returned messages in the footer:\n {0}", message);
            DataFooterMessageEvent dataFooterMessageEvent = new DataFooterMessageEvent((URL)object2, message);
            QueryRunner.getDataFooterMessageEventListener().onSdmxEvent(dataFooterMessageEvent);
        }
        return dataParsingResult;
    }

    private String mapSDMX2KeytoSDMX3FIlter(String string, DataFlowStructure dataFlowStructure) throws SdmxInvalidParameterException {
        String string2 = "";
        Dimension[] dimensionArray = dataFlowStructure.getDimensions().toArray(new Dimension[0]);
        String string3 = "[.]";
        String[] stringArray = string.split(string3);
        if (stringArray.length > dimensionArray.length) {
            throw new SdmxInvalidParameterException("The ts key is not valid: the dataflow does not contain so many dimensions.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].isEmpty() || stringArray[i].equals("*")) continue;
            string2 = string2 + (!string2.isEmpty() ? "&" : "") + "c[" + dimensionArray[i].getId() + "]=" + stringArray[i].replace("+", ",");
        }
        return string2;
    }

    private URL buildDataQuery(Dataflow dataflow, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws SdmxException {
        if (this.getProvider().getEndpoint() != null && dataflow != null) {
            Sdmx30Queries sdmx30Queries = (Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)this.getBuilder()).withFilter(string2)).withTimeFilter(string3, string4).withParam("attributes", string5)).withParam("measures", string6)).withParam("updatedAfter", string7)).withHistory(bl)).addPath("data")).addPath("dataflow")).addPath(dataflow.getFullIdentifier().replace(",", "/"));
            if (string != null && !string.isEmpty()) {
                sdmx30Queries = (Sdmx30Queries)sdmx30Queries.addPath(string);
            }
            return sdmx30Queries.build();
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " endpoint=" + this.getProvider().getEndpoint());
    }

    @Override
    protected URL buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        Utils.checkString(string2, "The name of the agency cannot be null");
        Utils.checkString(string, "The name of the data structure cannot be null");
        Sdmx30Queries sdmx30Queries = (Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)this.getBuilder()).addPath("structure")).addPath("datastructure")).addPath(string2)).addPath(string);
        if (string3 != null && !string3.isEmpty()) {
            sdmx30Queries.addPath(string3);
        }
        if (bl) {
            sdmx30Queries.withParam("references", "children");
        }
        return sdmx30Queries.build();
    }

    @Override
    protected URL buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        return ((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)this.getBuilder()).addPath("structure")).addPath("dataflow")).withRef(string2, string, string3)).build();
    }

    @Override
    protected URL buildCodelistQuery(String string, String string2, String string3) throws SdmxException {
        Utils.checkString(string, "The name of the codelist cannot be null");
        return ((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)this.getBuilder()).addPath("structure")).addPath("codelist")).withRef(string2, string, string3)).build();
    }

    protected URL buildAvailabilityQuery(Dataflow dataflow, String string, String string2) throws SdmxException {
        if (dataflow == null) {
            throw new SdmxInvalidParameterException("Invalid query parameters: dataflow=" + dataflow + " filter=" + string);
        }
        return ((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)this.getBuilder()).withFilter(string)).withParam("mode", string2)).addPath("availability")).addPath("dataflow")).addPath(dataflow.getFullIdentifier().replace(",", "/"))).build();
    }

    protected URL buildAvailabilityQueryByKey(Dataflow dataflow, String string, String string2) throws SdmxException {
        if (dataflow != null) {
            return ((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)((Sdmx30Queries)this.getBuilder()).withParam("mode", string2)).addPath("availability")).addPath("dataflow")).addPath(dataflow.getFullIdentifier().replace(",", "/"))).addPath(string)).build();
        }
        throw new SdmxInvalidParameterException("Invalid query parameters: dataflow=" + dataflow + " filter=" + string);
    }

    public static class Sdmx30Queries
    extends RestQueryBuilder<Sdmx30Queries> {
        public Sdmx30Queries(URI uRI) {
            super(uRI);
        }

        public Sdmx30Queries withTimeFilter(String string, String string2) {
            String string3 = string == null || string.isEmpty() ? "" : "ge:" + string;
            String string4 = string2 == null || string2.isEmpty() ? "" : "le:" + string2;
            String string5 = string3.isEmpty() || string4.isEmpty() ? "" : "+";
            String string6 = string3 + string5 + string4;
            return string6.isEmpty() ? this : (Sdmx30Queries)this.withParam("c[TIME_PERIOD]", string6);
        }
    }
}

