/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.api.BaseObservation;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.SdmxClientHandler;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.helper.ComparatorModel;
import it.bancaditalia.oss.sdmx.helper.SDMXHelper;
import it.bancaditalia.oss.sdmx.helper.SeriesModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class SeriesViewer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final JTable table = new JTable();
    private final JSlider precisionSlider = new JSlider();
    private final DefaultTableModel model;

    /*
     * WARNING - void declaration
     */
    public SeriesViewer(String string, String[] stringArray) throws SdmxException, IOException {
        super("Tabulate series");
        void var11_17;
        List<Object> list;
        this.setDefaultCloseOperation(2);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Precision");
        jMenu.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SeriesViewer.this.precisionSlider.requestFocus();
            }
        });
        jMenu.setMnemonic(80);
        jMenuBar.add(jMenu);
        this.precisionSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SeriesViewer.this.table.invalidate();
                SeriesViewer.this.table.repaint();
            }
        });
        this.precisionSlider.setMajorTickSpacing(1);
        this.precisionSlider.setSnapToTicks(true);
        this.precisionSlider.setPaintTicks(true);
        this.precisionSlider.setMaximum(14);
        this.precisionSlider.setValue(6);
        jMenu.add(this.precisionSlider);
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        ArrayList<PortableTimeSeries<Double>> arrayList = new ArrayList<PortableTimeSeries<Double>>();
        for (String object2 : hashSet) {
            arrayList.addAll(SdmxClientHandler.getTimeSeries(string, null, object2, null, null, null, false, null, false));
        }
        if (arrayList.size() < hashSet.size()) {
            throw new IllegalStateException("Couldn't download all series");
        }
        this.model = new ComparatorModel(hashSet);
        TreeMap treeMap = new TreeMap();
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        for (int iconRenderer = 0; iconRenderer < hashSet.size(); ++iconRenderer) {
            for (BaseObservation baseObservation : (PortableTimeSeries)arrayList.get(iconRenderer)) {
                list = (List)treeMap.get(baseObservation.getTimeslot());
                if (list == null) {
                    list = new ArrayList();
                }
                for (int i = list.size(); i < iconRenderer; ++i) {
                    list.add(null);
                }
                list.add(baseObservation.getValue());
                treeMap.put(baseObservation.getTimeslot(), list);
            }
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            BaseObservation baseObservation;
            baseObservation = (List)entry.getValue();
            while (baseObservation.size() < hashSet.size()) {
                baseObservation.add(null);
            }
            list = (String)entry.getKey();
            Double d = null;
            Double d2 = null;
            for (int i = 0; i < baseObservation.size(); ++i) {
                if (d == null || baseObservation.get(i) != null && d < (Double)baseObservation.get(i)) {
                    d = (Double)baseObservation.get(i);
                }
                if (d2 == null || baseObservation.get(i) != null && d2 > (Double)baseObservation.get(i)) {
                    d2 = (Double)baseObservation.get(i);
                }
                if (d2 != null) {
                    hashMap2.put((String)((Object)list), d2);
                }
                if (d == null) continue;
                hashMap.put((String)((Object)list), d);
            }
            baseObservation.add(0, list);
            this.model.addRow(baseObservation.toArray());
        }
        this.initialize();
        IconRenderer iconRenderer = new IconRenderer(hashMap, hashMap2);
        boolean bl = true;
        while (var11_17 < this.model.getColumnCount()) {
            this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView((int)var11_17)).setCellRenderer(iconRenderer);
            ++var11_17;
        }
    }

    public SeriesViewer(String string, String string2) throws SdmxException {
        super(string2);
        List<PortableTimeSeries<Double>> list = SdmxClientHandler.getTimeSeries(string, null, string2, null, null, null, false, null, false);
        if (list.size() != 1) {
            throw new IllegalStateException("Query must return exactly one time series");
        }
        PortableTimeSeries<Double> portableTimeSeries = list.iterator().next();
        Set<String> set = portableTimeSeries.getObsLevelAttributesNames();
        this.model = new SeriesModel(set);
        for (BaseObservation<Double> baseObservation : portableTimeSeries) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(baseObservation.getTimeslot());
            vector.add(baseObservation.getValue());
            for (String string3 : set) {
                vector.add(baseObservation.getAttributeValue(string3));
            }
            this.model.addRow(vector);
        }
        this.initialize();
    }

    private void initialize() {
        JScrollPane jScrollPane = new JScrollPane();
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.table.setModel(this.model);
        jScrollPane.setViewportView(this.table);
        this.setSize(450, 300);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    private class IconRenderer
    implements TableCellRenderer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, Double> maxes;
        private final Map<String, Double> mins;
        private final DefaultTableCellRenderer defRenderer = new DefaultTableCellRenderer();
        private final JPanel[] pane = new JPanel[]{new JPanel(), new JPanel()};
        private final JLabel minLabel = new JLabel();
        private final JLabel maxLabel = new JLabel();

        public IconRenderer(Map<String, Double> map, Map<String, Double> map2) {
            this.maxes = map;
            this.mins = map2;
            this.pane[0].setLayout(new BorderLayout());
            this.pane[1].setLayout(new BorderLayout());
            this.pane[0].add((Component)this.minLabel, "West");
            this.pane[1].add((Component)this.maxLabel, "West");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            String string2 = string = object != null ? object.toString() : "";
            if (object instanceof Double) {
                string = String.format(Locale.US, "%." + SeriesViewer.this.precisionSlider.getValue() + "f", object);
            }
            JLabel jLabel = (JLabel)this.defRenderer.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            jLabel.setHorizontalAlignment(4);
            if (jTable.convertColumnIndexToModel(n2) > 0 && object != null) {
                int n3 = jTable.getColumnModel().getColumn(n2).getPreferredWidth();
                int n4 = jTable.getRowHeight();
                String string3 = jTable.getValueAt(jTable.convertRowIndexToModel(n), jTable.convertColumnIndexToModel(0)).toString();
                if (object.equals(this.mins.get(string3))) {
                    if (this.minLabel.getIcon() == null || this.minLabel.getIcon().getIconHeight() != n4) {
                        this.minLabel.setIcon(new ImageIcon(SDMXHelper.ICON_MIN.getScaledInstance(n4, n4, 4)));
                    }
                    this.pane[0].add((Component)jLabel, "East");
                    this.pane[0].setForeground(jLabel.getForeground());
                    this.pane[0].setBackground(jLabel.getBackground());
                    this.pane[0].setPreferredSize(new Dimension(n3, n4));
                    return this.pane[0];
                }
                if (object.equals(this.maxes.get(string3))) {
                    if (this.maxLabel.getIcon() == null || this.maxLabel.getIcon().getIconHeight() != n4) {
                        this.maxLabel.setIcon(new ImageIcon(SDMXHelper.ICON_MAX.getScaledInstance(n4, n4, 4)));
                    }
                    this.pane[1].add((Component)jLabel, "East");
                    this.pane[1].setForeground(jLabel.getForeground());
                    this.pane[1].setBackground(jLabel.getBackground());
                    this.pane[1].setPreferredSize(new Dimension(n3, n4));
                    return this.pane[1];
                }
                jLabel.setPreferredSize(new Dimension(n3, n4));
            }
            return jLabel;
        }
    }
}

