/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.client.RestSdmxClient;
import it.bancaditalia.oss.sdmx.client.SdmxClientHandler;
import it.bancaditalia.oss.sdmx.event.DataFooterMessageEvent;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.parser.v21.GenericDataParser;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;

public class BBK
extends RestSdmxClient {
    private static final String BBK_PROVIDER = "https://api.statistiken.bundesbank.de/rest";

    public BBK() throws URISyntaxException {
        super("Eurostat", new URI(BBK_PROVIDER), false, false, false);
    }

    @Override
    protected URL buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        try {
            return new URL(this.endpoint + "/metadata/dataflow/BBK" + (string.equalsIgnoreCase("all") ? "" : "/" + string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new SdmxInvalidParameterException("Invalid query parameters: dataflow: " + string + ", endpoint=" + this.endpoint);
        }
    }

    @Override
    protected URL buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        try {
            return new URL(this.endpoint + "/metadata/datastructure/BBK" + (string.equalsIgnoreCase("all") ? "" : "/" + string) + "?references=children");
        }
        catch (MalformedURLException malformedURLException) {
            throw new SdmxInvalidParameterException("Invalid query parameters: dsd: " + string + ", endpoint=" + this.endpoint);
        }
    }

    @Override
    protected URL buildCodelistQuery(String string, String string2, String string3) throws SdmxException {
        try {
            return new URL(this.endpoint + "/metadata/codelist/BBK" + (string.equalsIgnoreCase("all") ? "" : "/" + string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new SdmxInvalidParameterException("Invalid query parameters: codelist: " + string + ", endpoint=" + this.endpoint);
        }
    }

    @Override
    protected DataParsingResult getData(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        URL uRL;
        DataParsingResult dataParsingResult = this.runQuery(new GenericDataParser(dataFlowStructure, dataflow, !bl), uRL = this.buildDataQuery(new Dataflow(dataflow.getId(), null, null, null), string, string2, string3, false, null, false), "application/xml", null);
        Message message = dataParsingResult.getMessage();
        if (message != null) {
            LOGGER.log(Level.INFO, "The sdmx call returned messages in the footer:\n {0}", message);
            DataFooterMessageEvent dataFooterMessageEvent = new DataFooterMessageEvent(uRL, message);
            this.dataFooterMessageEventListener.onSdmxEvent(dataFooterMessageEvent);
        }
        return dataParsingResult;
    }

    public static void main(String[] stringArray) throws SdmxException {
        System.err.println(SdmxClientHandler.getDataFlowStructure("BBK", "BBAI3"));
    }
}

