/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.AbstractLinearSystemSolver;
import ec.tstoolkit.maths.matrices.IQrDecomposition;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SubMatrix;

public class Householder
extends AbstractLinearSystemSolver
implements IQrDecomposition {
    private double[] m_qr;
    private double[] m_rdiag;
    private int[] m_unused;
    private int m_norig;
    private int m_n;
    private int m_m;
    private boolean m_bclone;

    public Householder(boolean clone) {
        this.m_bclone = clone;
    }

    @Override
    public void decompose(Matrix m) {
        if (this.m_bclone) {
            this.init(m.clone());
        } else {
            this.init(m);
        }
        this.householder();
    }

    @Override
    public void decompose(SubMatrix m) {
        this.init(new Matrix(m));
        this.householder();
    }

    @Override
    public int getEquationsCount() {
        return this.m_m;
    }

    @Override
    public Matrix getR() {
        Matrix r = new Matrix(this.m_n, this.m_n);
        double[] data = r.data_;
        int i = 0;
        int k = 0;
        int l = 0;
        while (i < this.m_n) {
            for (int j = 0; j < i; ++j) {
                data[k + j] = this.m_qr[l + j];
            }
            data[k + i] = this.m_rdiag[i];
            ++i;
            k += this.m_n;
            l += this.m_m;
        }
        return r;
    }

    public int getRank() {
        return this.m_n;
    }

    @Override
    public DataBlock getRDiagonal() {
        return new DataBlock(this.m_rdiag);
    }

    @Override
    public int getUnknownsCount() {
        return this.m_norig;
    }

    public int[] getUnused() {
        return this.m_unused;
    }

    private void householder() {
        int[] unused = new int[this.m_norig];
        int nunused = 0;
        int nrdiag = 0;
        double eps = this.getEpsilon();
        int len = this.m_qr.length;
        int l = 0;
        int km = 0;
        for (int k = 0; k < this.m_n; ++k) {
            DataBlock col = new DataBlock(this.m_qr, km + l, km + this.m_m, 1);
            double nrm = col.nrm2();
            if (nrm > eps) {
                if (this.m_qr[l + km] < -eps) {
                    nrm = -nrm;
                }
                for (int i = l; i < this.m_m; ++i) {
                    int n = i + km;
                    this.m_qr[n] = this.m_qr[n] / nrm;
                }
                int n = l + km;
                this.m_qr[n] = this.m_qr[n] + 1.0;
                this.m_rdiag[nrdiag++] = -nrm;
                for (int jm = km + this.m_m; jm < len; jm += this.m_m) {
                    int i;
                    double s = 0.0;
                    for (i = l; i < this.m_m; ++i) {
                        s += this.m_qr[i + km] * this.m_qr[i + jm];
                    }
                    s /= -this.m_qr[l + km];
                    for (i = l; i < this.m_m; ++i) {
                        int n2 = i + jm;
                        this.m_qr[n2] = this.m_qr[n2] + s * this.m_qr[i + km];
                    }
                }
                km += this.m_m;
                ++l;
                continue;
            }
            unused[nunused++] = k;
            System.arraycopy(this.m_qr, km + this.m_m, this.m_qr, km, (len -= this.m_m) - km);
        }
        if (nunused > 0) {
            this.m_unused = new int[nunused];
            System.arraycopy(unused, 0, this.m_unused, 0, nunused);
            for (int i = 0; i < this.m_unused.length; ++i) {
                int n = this.m_unused[i];
            }
            this.m_n -= nunused;
        } else {
            this.m_unused = null;
        }
    }

    private void init(Matrix m) {
        this.m_m = m.getRowsCount();
        this.m_norig = this.m_n = m.getColumnsCount();
        this.m_qr = m.data_;
        this.m_rdiag = new double[this.m_n];
    }

    @Override
    public boolean isFullRank() {
        return this.m_n == this.m_norig;
    }

    @Override
    public void leastSquares(IReadDataBlock x, IDataBlock b, IDataBlock res) {
        double[] y = new double[x.getLength()];
        x.copyTo(y, 0);
        this.applyQt(y);
        if (res != null) {
            res.copyFrom(y, this.m_n);
        }
        double eps = this.getEpsilon() * 1000.0;
        for (int k = this.m_n - 1; k >= 0; --k) {
            int i;
            double dk = this.m_rdiag[k];
            if (Math.abs(dk) > eps) {
                int n = k;
                y[n] = y[n] / dk;
                for (i = 0; i < k; ++i) {
                    int n2 = i;
                    y[n2] = y[n2] - y[k] * this.m_qr[i + k * this.m_m];
                }
                continue;
            }
            for (i = 0; i < k; ++i) {
                double xcur = this.m_qr[i + k * this.m_m];
                if (!(Math.abs(xcur) > eps)) continue;
                throw new MatrixException("m_err_rank");
            }
        }
        b.copyFrom(y, 0);
    }

    public void applyQ(double[] b) {
        for (int k = this.m_n - 1; k >= 0; --k) {
            int i;
            double s = 0.0;
            for (i = k; i < this.m_m; ++i) {
                s += this.m_qr[k * this.m_m + i] * b[i];
            }
            s = -s / this.m_qr[k * this.m_m + k];
            for (i = k; i < this.m_m; ++i) {
                int n = i;
                b[n] = b[n] + s * this.m_qr[k * this.m_m + i];
            }
        }
    }

    public void applyQt(double[] b) {
        int k = 0;
        int km = 0;
        while (k < this.m_n) {
            int i;
            double s = 0.0;
            for (i = k; i < this.m_m; ++i) {
                s += this.m_qr[km + i] * b[i];
            }
            if (s != 0.0) {
                s = -s / this.m_qr[km + k];
                for (i = k; i < this.m_m; ++i) {
                    int n = i;
                    b[n] = b[n] + s * this.m_qr[km + i];
                }
            }
            ++k;
            km += this.m_m;
        }
    }

    @Override
    public void solve(DataBlock xin, DataBlock xout) {
        this.leastSquares(xin, xout, null);
    }

    @Override
    public double[] solve(double[] x) {
        if (this.m_norig != this.m_n) {
            throw new MatrixException("m_err_sing");
        }
        double[] b = new double[this.m_n];
        this.leastSquares(new DataBlock(x), new DataBlock(b), null);
        return b;
    }
}

