/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.DurbinAlgorithm;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;

public class AutoRegressiveSpectrum {
    public static final int MAX_AR = 50;
    private double[] ar;
    private double sig;
    private final Method method_;

    public AutoRegressiveSpectrum(Method m) {
        this.method_ = m;
    }

    public boolean process(IReadDataBlock data, int nar) {
        int nlags;
        this.clear();
        int n = nlags = nar == 0 ? AutoRegressiveSpectrum.computeDefaultLags(data.getLength()) : nar;
        if (nlags < 0) {
            return false;
        }
        switch (this.method_) {
            case Durbin: {
                this.computeDurbin(data, nlags);
                break;
            }
            case Ols: {
                this.computeOls(data, nlags);
            }
        }
        return this.ar != null;
    }

    private void clear() {
        this.ar = null;
        this.sig = 0.0;
    }

    private void computeDurbin(IReadDataBlock data, int nar) {
        DurbinAlgorithm durbin = new DurbinAlgorithm();
        if (durbin.solve(data, nar)) {
            this.ar = durbin.getCoefficients();
        }
        this.sig = durbin.getInnovationVariance();
    }

    public static int computeDefaultLags(int n) {
        double ln = Math.log(n);
        int npi = (int)(ln * ln);
        if (npi > 50) {
            npi = 50;
        }
        if (npi > n - n / 4) {
            return -1;
        }
        return npi;
    }

    private void computeOls(IReadDataBlock data, int nar) {
        try {
            int i;
            this.clear();
            int n = data.getLength();
            double[] all = new double[n];
            data.copyTo(all, 0);
            double m = 0.0;
            for (i = 0; i < all.length; ++i) {
                if (Double.isNaN(all[i])) {
                    all[i] = 0.0;
                    continue;
                }
                m += all[i];
            }
            m /= (double)all.length;
            i = 0;
            while (i < all.length) {
                int n2 = i++;
                all[n2] = all[n2] - m;
            }
            int nc = n - nar;
            if (nc < nar) {
                return;
            }
            Matrix M = new Matrix(nc, nar);
            DataBlock rc = new DataBlock(all, nar, n, 1);
            DataBlockIterator cols = M.columns();
            DataBlock col = cols.getData();
            do {
                rc.move(-1);
                col.copy(rc);
            } while (cols.next());
            Householder qr = new Householder(false);
            qr.decompose(M);
            this.ar = new double[nar];
            DataBlock c = new DataBlock(this.ar);
            DataBlock e = new DataBlock(nc - nar);
            qr.leastSquares(new DataBlock(all, nar, n, 1), c, e);
            c.chs();
            this.sig = e.ssq() / (double)nc;
        }
        catch (MatrixException err) {
            this.clear();
        }
    }

    public double value(double f) {
        if (f < 0.0 || f > Math.PI) {
            throw new IllegalArgumentException();
        }
        double c2 = 1.0;
        double s2 = 0.0;
        for (int j = 0; j < this.ar.length; ++j) {
            double dj = (double)(j + 1) * f;
            c2 += this.ar[j] * Math.cos(dj);
            s2 += this.ar[j] * Math.sin(dj);
        }
        double p = this.sig / (c2 * c2 + s2 * s2);
        if (p <= 0.0) {
            return 0.0;
        }
        return Math.log10(p) * 10.0;
    }

    public double getSigma() {
        return this.sig;
    }

    public IReadDataBlock getCoefficients() {
        return this.ar != null ? new ReadDataBlock(this.ar) : DataBlock.EMPTY;
    }

    public static enum Method {
        Ols,
        Durbin;

    }
}

