/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special;

import ec.tstoolkit.arima.special.MixedAirlineCompositeModel;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaModelBuilder;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.SsfComposite;

public class MixedAirlineModel {
    private double th_ = -0.2;
    private double bth_ = -0.2;
    private double svar_;
    private int[] np_;
    private int freq_ = 12;

    public void setNoisyPeriods(int[] periods) {
        this.np_ = (int[])periods.clone();
    }

    public int[] getNoisyPeriods() {
        return this.np_;
    }

    public boolean stabilize() {
        boolean changed = false;
        if (Math.abs(this.th_) > 1.0) {
            this.th_ = 1.0 / this.th_;
            changed = true;
        }
        if (Math.abs(this.bth_) > 1.0) {
            this.bth_ = 1.0 / this.bth_;
            changed = true;
        }
        return changed;
    }

    public SarimaModel getAirline() {
        SarimaModelBuilder builder = new SarimaModelBuilder();
        return builder.createAirlineModel(this.freq_, this.th_, this.bth_);
    }

    public void setAirline(SarimaModel model) {
        this.freq_ = model.getFrequency();
        this.th_ = model.theta(1);
        this.bth_ = model.btheta(1);
    }

    public double getNoisyPeriodsVariance() {
        return this.svar_;
    }

    public void setNoisyPeriodsVariance(double svar) {
        this.svar_ = svar;
    }

    public double getTheta() {
        return this.th_;
    }

    public void setTheta(double th) {
        this.th_ = th;
    }

    public double getBTheta() {
        return this.bth_;
    }

    public void setBTheta(double bth) {
        this.bth_ = bth;
    }

    public ISsf makeSsf() {
        return new SsfComposite(new MixedAirlineCompositeModel(this));
    }

    public void setFrequency(int freq) {
        this.freq_ = freq;
    }

    public int getFrequency() {
        return this.freq_;
    }

    public String toString() {
        if (this.np_.length == 0) {
            return "airline";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        builder.append(this.np_[0] + 1);
        for (int i = 1; i < this.np_.length; ++i) {
            builder.append("  ").append(this.np_[i] + 1);
        }
        builder.append(']');
        return builder.toString();
    }
}

