/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.cholette;

import ec.benchmarking.cholette.ISummation;
import ec.benchmarking.cholette.IVariance;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;

public class Summation
implements ISummation {
    private int beg_ = 0;
    private int end_;
    private int conv_;
    private int n_;

    public Summation(int n, int iconv) {
        this.n_ = n;
        this.conv_ = iconv;
        this.end_ = n - n % iconv;
    }

    @Override
    public Matrix BAB(IVariance var) {
        int m = this.sdim();
        Matrix M = new Matrix(m, m);
        for (int r = 0; r < m; ++r) {
            for (int c = 0; c <= r; ++c) {
                double s = 0.0;
                int R0 = this.beg_ + this.conv_ * r;
                int C0 = this.beg_ + this.conv_ * c;
                for (int i = R0; i < R0 + this.conv_; ++i) {
                    for (int j = C0; j < C0 + this.conv_; ++j) {
                        s += var.var(i, j);
                    }
                }
                M.set(r, c, s);
            }
        }
        SymmetricMatrix.fromLower(M);
        return M;
    }

    @Override
    public double Btz(int i, DataBlock z) {
        int i0 = this.beg_ + i * this.conv_;
        DataBlock x = z.range(i0, i0 + this.conv_);
        return x.sum();
    }

    @Override
    public double Bx(int i, DataBlock x) {
        if (i < this.beg_ || i >= this.end_) {
            return 0.0;
        }
        return x.get((i - this.beg_) / this.conv_);
    }

    @Override
    public int dim() {
        return this.n_;
    }

    @Override
    public int sdim() {
        return (this.end_ - this.beg_) / this.conv_;
    }
}

