/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.AsymmetricEndPoints;
import ec.satoolkit.x11.DefaultTrendFilteringStrategy;
import ec.satoolkit.x11.DefaultX11Algorithm;
import ec.satoolkit.x11.ITrendCycleComputer;
import ec.satoolkit.x11.MusgraveFilterFactory;
import ec.satoolkit.x11.SeriesEvolution;
import ec.satoolkit.x11.TrendCycleFilterFactory;
import ec.satoolkit.x11.X11Step;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

class AutomaticTrendCycleComputer
extends DefaultX11Algorithm
implements ITrendCycleComputer {
    private double curIC;

    AutomaticTrendCycleComputer() {
    }

    @Override
    public TsData doFinalFiltering(X11Step step, TsData s, InformationSet info) {
        int freq = this.context.getFrequency();
        if (step == X11Step.B) {
            this.curIC = freq == 4 ? 0.001 : 3.5;
        }
        int filterLength = freq + 1;
        SymmetricFilter trendFilter = TrendCycleFilterFactory.makeHendersonFilter(filterLength);
        DefaultTrendFilteringStrategy strategy = new DefaultTrendFilteringStrategy(trendFilter, null, filterLength + " terms Henderson moving average");
        TsData sc = strategy.process(s, s.getDomain());
        TsData si = this.op(s, sc);
        int nf = this.context.getForecastHorizon();
        int nb = this.context.getBackcastHorizon();
        TsDomain gdom = nf == 0 && nb == 0 ? null : sc.getDomain().drop(nb, nf);
        double gc = SeriesEvolution.calcAbsMeanVariations(sc, gdom, 1, this.isMultiplicative(), this.context.getValidDecomposition());
        double gi = SeriesEvolution.calcAbsMeanVariations(si, gdom, 1, this.isMultiplicative(), this.context.getValidDecomposition());
        double icr = gi / gc;
        if (freq == 4) {
            icr *= 3.0;
        } else if (freq == 2) {
            icr *= 6.0;
        }
        filterLength = this.selectFilter(step, icr, freq);
        double r = freq == 2 ? 0.001 : this.curIC;
        if (filterLength == trendFilter.getLength()) {
            int len = filterLength / 2;
            sc = sc.extend(len, len);
            AsymmetricEndPoints iep = new AsymmetricEndPoints(MusgraveFilterFactory.makeFilters(trendFilter, r));
            iep.process(new DataBlock(s.internalStorage()), new DataBlock(sc.internalStorage()));
            if (step == X11Step.D) {
                info.subSet("d-tables").set("d12filter", strategy.getDescription());
                info.subSet("d-tables").set("tlen", Integer.valueOf(filterLength));
            }
            return sc;
        }
        trendFilter = TrendCycleFilterFactory.makeHendersonFilter(filterLength);
        AsymmetricEndPoints iep = new AsymmetricEndPoints(MusgraveFilterFactory.makeFilters(trendFilter, r));
        strategy = new DefaultTrendFilteringStrategy(trendFilter, iep, filterLength + "-Henderson");
        if (step == X11Step.D) {
            info.subSet("d-tables").set("d12filter", strategy.getDescription());
            info.subSet("d-tables").set("tlen", Integer.valueOf(filterLength));
        }
        return strategy.process(s, s.getDomain());
    }

    @Override
    public TsData doInitialFiltering(X11Step step, TsData s, InformationSet info) {
        SymmetricFilter trendFilter = TrendCycleFilterFactory.makeTrendFilter(this.context.getFrequency());
        return new DefaultTrendFilteringStrategy(trendFilter, null).process(s, s.getDomain());
    }

    private int selectFilter(X11Step step, double icr, int freq) {
        if (freq == 2) {
            return 5;
        }
        if (step == X11Step.B && icr >= 1.0 || icr >= 1.0 && icr < 3.5) {
            return freq + 1;
        }
        if (icr < 1.0) {
            if (freq == 12) {
                this.curIC = 1.0;
                return 9;
            }
            return 5;
        }
        this.curIC = 4.5;
        return freq == 12 ? 23 : 7;
    }
}

