/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.AbstractOutlierVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class TransitoryChange
extends AbstractOutlierVariable {
    public static final String CODE = "TC";
    private final double coefficient;
    private final boolean monthlyCoefficient;
    static double ZERO = 1.0E-15;

    public TransitoryChange(Day p) {
        super(p);
        this.coefficient = 0.7;
        this.monthlyCoefficient = false;
    }

    public TransitoryChange(Day p, double c) {
        super(p);
        this.coefficient = c;
        this.monthlyCoefficient = false;
    }

    public TransitoryChange(Day p, double c, boolean monthlyCoefficient) {
        super(p);
        this.coefficient = c;
        this.monthlyCoefficient = monthlyCoefficient;
    }

    private double coefficient(int freq) {
        int r;
        double c = this.coefficient;
        if (this.monthlyCoefficient && (r = 12 / freq) > 1) {
            c = Math.pow(c, r);
        }
        return c;
    }

    @Override
    public void data(TsPeriod start, DataBlock data) {
        int i;
        data.set(0.0);
        double cur = 1.0;
        int n = data.getLength();
        TsPeriod pstart = new TsPeriod(start.getFrequency(), this.position);
        double c = this.coefficient(start.getFrequency().intValue());
        for (i = pstart.minus(start); i < 0; ++i) {
            if (!(Math.abs(cur *= c) < ZERO)) continue;
            return;
        }
        while (i < n) {
            data.set(i, cur);
            cur *= c;
            if (Math.abs(cur) < ZERO) {
                return;
            }
            ++i;
        }
    }

    public double getCoefficient() {
        return this.coefficient;
    }

    public boolean isMonthlyCoefficient() {
        return this.monthlyCoefficient;
    }

    @Override
    public OutlierType getOutlierType() {
        return OutlierType.TC;
    }

    @Override
    public String getCode() {
        return CODE;
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        int n = domain.search(this.position);
        return n >= 0 && n < domain.getLength() - 1;
    }

    @Override
    public IOutlierVariable.FilterRepresentation getFilterRepresentation(int freq) {
        return new IOutlierVariable.FilterRepresentation(new RationalBackFilter(BackFilter.ONE, BackFilter.of(new double[]{1.0, -this.coefficient(freq)})), 0.0);
    }
}

