/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ITaper;

public class DurbinAlgorithm {
    private double[] cxx_;
    private double sd;
    private double aic;
    private double[] x_;
    private double[] a_;
    private static final double SMALL = 1.0E-9;
    private boolean mean_ = true;
    private ITaper taper_;

    public double getAutocovariance(int lag) {
        return this.cxx_[lag];
    }

    public int getMaxLag() {
        return this.cxx_ == null ? 0 : this.cxx_.length - 1;
    }

    public void setTaper(ITaper taper) {
        this.taper_ = taper;
    }

    public ITaper getTaper() {
        return this.taper_;
    }

    public boolean solve(IReadDataBlock x, int l) {
        this.x_ = new double[x.getLength()];
        x.copyTo(this.x_, 0);
        return this.calc(l);
    }

    public double[] getCoefficients() {
        return this.a_;
    }

    public double getAIC() {
        return this.aic;
    }

    public double getInnovationVariance() {
        return this.sd;
    }

    public boolean isMeanCorrection() {
        return this.mean_;
    }

    public void setMeanCorrection(boolean mean) {
        this.mean_ = mean;
    }

    private boolean calc(int l) {
        if (!this.checkMean()) {
            return false;
        }
        if (this.taper_ != null) {
            this.taper_.process(this.x_);
        }
        if (!this.calcCov(l)) {
            return false;
        }
        this.iterate(l);
        return true;
    }

    private boolean checkMean() {
        int i;
        double sum = 0.0;
        int nm = 0;
        for (i = 0; i < this.x_.length; ++i) {
            if (!Double.isFinite(this.x_[i])) {
                ++nm;
                continue;
            }
            if (!this.mean_) continue;
            sum += this.x_[i];
        }
        if (nm == this.x_.length) {
            return false;
        }
        if (sum != 0.0) {
            sum /= (double)(this.x_.length - nm);
            for (i = 0; i < this.x_.length; ++i) {
                if (!Double.isFinite(this.x_[i])) continue;
                int n = i;
                this.x_[n] = this.x_[n] - sum;
            }
        }
        return true;
    }

    private boolean calcCov(int l) {
        this.cxx_ = new double[l + 1];
        for (int i = 0; i <= l; ++i) {
            this.cxx_[i] = DescriptiveStatistics.cov(i, this.x_);
        }
        double v = this.cxx_[0];
        return !DescriptiveStatistics.isSmall(v);
    }

    private void iterate(int l) {
        double sdr;
        double caic;
        this.a_ = new double[l];
        int n = this.x_.length;
        double csd = this.cxx_[0];
        this.aic = caic = (double)n * Math.log(csd);
        this.sd = csd;
        double se = this.cxx_[1];
        double[] b = new double[l];
        for (int m = 0; m < l && !((sdr = csd / this.cxx_[0]) < 1.0E-9); ++m) {
            int i;
            double d;
            this.a_[m] = d = se / csd;
            csd = (1.0 - d * d) * csd;
            caic = (double)n * Math.log(csd) + (double)(2 * (m + 1));
            if (m != 0) {
                for (i = 0; i <= m - 1; ++i) {
                    int n2 = i;
                    this.a_[n2] = this.a_[n2] - d * b[i];
                }
            }
            for (i = 0; i <= m; ++i) {
                b[i] = this.a_[m - i];
            }
            if (this.aic > caic) {
                this.aic = caic;
                this.sd = csd;
            }
            if (m == l - 1) continue;
            se = this.cxx_[m + 2];
            for (i = 0; i <= m; ++i) {
                se -= b[i] * this.cxx_[i + 1];
            }
        }
        for (int i = 0; i < l; ++i) {
            this.a_[i] = -this.a_[i];
        }
    }
}

