/*
 * Decompiled with CFR 0.152.
 */
package demetra.workspace.file;

import demetra.workspace.file.Index;
import demetra.workspace.io.IoUtil;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nonnull;

interface Indexer
extends Closeable {
    public void checkId(@Nonnull Index.Key var1) throws IOException;

    @Nonnull
    public Index loadIndex() throws IOException;

    public void storeIndex(@Nonnull Index var1) throws IOException;

    @Nonnull
    default public Indexer memoize() {
        final Indexer delegate = this;
        return new Indexer(){
            private Index latest;
            private boolean storeRequired;

            @Override
            public void checkId(Index.Key id) throws IOException {
                delegate.checkId(id);
            }

            @Override
            public Index loadIndex() throws IOException {
                if (this.latest == null) {
                    this.latest = delegate.loadIndex();
                    this.storeRequired = false;
                }
                return this.latest;
            }

            @Override
            public void storeIndex(Index index) throws IOException {
                this.latest = index;
                this.storeRequired = true;
            }

            @Override
            public void close() throws IOException {
                IoUtil.closeAll(this::flushIndex, delegate::close);
            }

            private void flushIndex() throws IOException {
                if (this.latest != null && this.storeRequired) {
                    delegate.storeIndex(this.latest);
                }
            }
        };
    }
}

