/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.ChangeOfRegimeSpec;
import ec.tstoolkit.modelling.RegressionTestSpec;
import java.util.Map;
import java.util.Objects;

public class MovingHolidaySpec
implements Cloneable,
InformationSetSerializable {
    public static final String TYPE = "type";
    public static final String PARAM = "param";
    public static final String TEST = "test";
    public static final String CHANGEOFREGIME = "changeofregime";
    public static final int DEF_EASTERDUR = 8;
    private ChangeOfRegimeSpec changeofregime_;
    private int w_;
    private RegressionTestSpec test_ = RegressionTestSpec.None;
    private Type type_;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, TYPE), String.class);
        dic.put(InformationSet.item(prefix, PARAM), Integer.class);
        dic.put(InformationSet.item(prefix, TEST), String.class);
        dic.put(InformationSet.item(prefix, CHANGEOFREGIME), String.class);
    }

    public static MovingHolidaySpec easterSpec(boolean pretest) {
        return MovingHolidaySpec.easterSpec(pretest, false);
    }

    public static MovingHolidaySpec easterSpec(boolean pretest, boolean julian) {
        MovingHolidaySpec easter = new MovingHolidaySpec();
        easter.test_ = RegressionTestSpec.Add;
        easter.type_ = julian ? Type.JulianEaster : Type.Easter;
        easter.w_ = 8;
        easter.test_ = pretest ? RegressionTestSpec.Add : RegressionTestSpec.None;
        return easter;
    }

    public Type getType() {
        return this.type_;
    }

    public void setType(Type value) {
        this.type_ = value;
    }

    public int getW() {
        return this.w_;
    }

    public void setW(int value) {
        if (value <= 0 || value > 25) {
            throw new IllegalArgumentException("Should be in [1,25]");
        }
        this.w_ = value;
    }

    public ChangeOfRegimeSpec getChangeOfRegime() {
        return this.changeofregime_;
    }

    public void setChangeOfRegime(ChangeOfRegimeSpec value) {
        this.changeofregime_ = value;
    }

    public RegressionTestSpec getTest() {
        return this.test_;
    }

    public void setTest(RegressionTestSpec value) {
        this.test_ = value;
    }

    public MovingHolidaySpec clone() {
        try {
            MovingHolidaySpec rslt = (MovingHolidaySpec)super.clone();
            if (this.changeofregime_ != null) {
                rslt.changeofregime_ = this.changeofregime_.clone();
            }
            return rslt;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof MovingHolidaySpec && this.equals((MovingHolidaySpec)obj);
    }

    private boolean equals(MovingHolidaySpec other) {
        return Objects.equals(this.changeofregime_, other.changeofregime_) && this.test_ == other.test_ && this.type_ == other.type_ && this.w_ == other.w_;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + Objects.hashCode(this.changeofregime_);
        hash = 53 * hash + this.w_;
        hash = 53 * hash + Objects.hashCode((Object)this.test_);
        hash = 53 * hash + Objects.hashCode((Object)this.type_);
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.add(TYPE, this.type_.name());
        if (verbose || this.w_ != 0) {
            info.add(PARAM, Integer.valueOf(this.w_));
        }
        if (verbose || this.test_ != RegressionTestSpec.None) {
            info.add(TEST, this.test_.name());
        }
        if (this.changeofregime_ != null) {
            info.add(CHANGEOFREGIME, this.changeofregime_.toString());
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            String cr;
            String test;
            String type = info.get(TYPE, String.class);
            if (type == null) {
                return false;
            }
            this.type_ = Type.valueOf(type);
            Integer w = info.get(PARAM, Integer.class);
            if (w != null) {
                this.w_ = w;
            }
            if ((test = info.get(TEST, String.class)) != null) {
                this.test_ = RegressionTestSpec.valueOf(test);
            }
            if ((cr = info.get(CHANGEOFREGIME, String.class)) != null) {
                this.changeofregime_ = ChangeOfRegimeSpec.fromString(cr);
                if (this.changeofregime_ == null) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public static enum Type {
        None,
        Easter,
        Thank,
        SCEaster,
        Labor,
        JulianEaster;

    }
}

