/*
 * Decompiled with CFR 0.152.
 */
package demetra.xml;

import demetra.datatypes.TsCollection;
import demetra.datatypes.TsMoniker;
import demetra.xml.IXmlConverter;
import demetra.xml.XmlMetaData;
import demetra.xml.XmlTs;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="tsCollection")
@XmlType(name="tsCollectionType")
public class XmlTsCollection
implements IXmlConverter<TsCollection> {
    static final String NAME = "tsCollectionType";
    static final String RNAME = "tsCollection";
    @XmlElement
    public XmlMetaData metadata;
    @XmlAttribute
    public String name;
    @XmlAttribute
    public String source;
    @XmlAttribute
    public String identifier;
    @XmlElement(name="ts")
    @XmlElementWrapper(name="data")
    public XmlTs[] tslist;

    @Override
    public void copy(TsCollection t) {
        this.source = t.getMoniker().getSource();
        this.identifier = t.getMoniker().getId();
        this.name = t.getName();
        if (t.getMetaData().isEmpty()) {
            this.metadata = null;
        } else {
            this.metadata = new XmlMetaData();
            this.metadata.copy(t.getMetaData());
        }
        int n = t.getItems().size();
        if (n > 0) {
            this.tslist = new XmlTs[n];
            for (int i = 0; i < n; ++i) {
                XmlTs s = new XmlTs();
                s.copy(t.getItems().get(i));
                this.tslist[i] = s;
            }
        } else {
            this.tslist = null;
        }
    }

    @Override
    public TsCollection create() {
        TsMoniker moniker = TsMoniker.create(this.source, this.identifier);
        TsCollection.Builder builder = TsCollection.builder().moniker(moniker).name(this.name).metaData((Map<? extends String, ? extends String>)this.metadata.create());
        if (this.tslist != null) {
            for (int i = 0; i < this.tslist.length; ++i) {
                builder.item(this.tslist[i].create());
            }
        }
        return builder.build();
    }
}

