/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

public class UMatrix {
    double R;
    double Z;
    double[] K;
    double[] L;
    double m_eps = 1.0E-15;

    UMatrix() {
    }

    boolean triangularize() {
        double jsigma = -this.Z * this.Z;
        if (-jsigma <= this.m_eps) {
            return true;
        }
        double xJx = jsigma + this.R * this.R;
        if (xJx <= 0.0) {
            return false;
        }
        double jnrm = Math.sqrt(xJx);
        double v = -jsigma / (this.R + jnrm);
        double w = this.Z;
        this.R = jnrm;
        this.Z = 0.0;
        double beta = 2.0 / (jsigma + v * v);
        int nr = this.K.length;
        int k = 0;
        while (k < nr) {
            double s = (this.K[k] * v - this.L[k] * w) * beta;
            int n = k;
            this.K[n] = this.K[n] - s * v;
            int n2 = k++;
            this.L[n2] = this.L[n2] - s * w;
        }
        return true;
    }
}

