/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.IDomain;
import ec.tstoolkit.timeseries.IPeriod;

public class DomainConverter {
    private IDomain m_ndom;
    private IDomain m_odom;
    private int[] m_start;
    private int[] m_end;

    private void adjustendpos() {
        for (int i = 0; i < this.m_end.length; ++i) {
            if (this.m_end[i] < 0) continue;
            int n = i;
            this.m_end[n] = this.m_end[n] + 1;
        }
    }

    private void clear() {
        this.m_start = null;
        this.m_end = null;
    }

    public boolean convert(IDomain newdom, IDomain olddom) {
        this.init(newdom, olddom);
        if (this.search()) {
            this.adjustendpos();
            return true;
        }
        this.clear();
        return false;
    }

    public int endPos(int idx) {
        return this.m_end[idx];
    }

    public IDomain getNewDomain() {
        return this.m_ndom;
    }

    public IDomain getOldDomain() {
        return this.m_odom;
    }

    private void init(IDomain newdom, IDomain olddom) {
        this.m_ndom = newdom;
        this.m_odom = olddom;
        int n = this.m_ndom.getLength();
        this.m_start = new int[n];
        this.m_end = new int[n];
        for (int i = 0; i < n; ++i) {
            this.m_start[i] = -1;
            this.m_end[i] = -1;
        }
    }

    private boolean search() {
        int nold = this.m_odom.getLength();
        for (int i = 0; i < nold; ++i) {
            int endpos;
            IPeriod oldp = this.m_odom.get(i);
            Day start = oldp.firstday();
            Day end = oldp.lastday();
            int pos = this.m_ndom.search(start);
            if (pos < 0) continue;
            if (start != end && pos != (endpos = this.m_ndom.search(end))) {
                return false;
            }
            if (this.m_start[pos] == -1 || this.m_start[pos] > i) {
                this.m_start[pos] = i;
            }
            if (this.m_end[pos] != -1 && this.m_end[pos] >= i) continue;
            this.m_end[pos] = i;
        }
        return true;
    }

    public int startPos(int idx) {
        return this.m_start[idx];
    }
}

