/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.eco.DefaultLikelihoodEvaluation;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.ssf.AbstractSsfAlgorithm;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.DiffusePredictionErrorDecomposition;
import ec.tstoolkit.ssf.Filter;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfAlgorithm;
import ec.tstoolkit.ssf.ISsfInitializer;
import ec.tstoolkit.ssf.SsfModel;

public class SsfAlgorithm<F extends ISsf>
extends AbstractSsfAlgorithm
implements ISsfAlgorithm<F> {
    private ISsfInitializer<F> m_initializer;

    public SsfAlgorithm() {
    }

    public SsfAlgorithm(ISsfInitializer<F> initializer) {
        this.m_initializer = initializer;
    }

    public DefaultLikelihoodEvaluation<DiffuseConcentratedLikelihood> calcNoRegs(SsfModel<F> instance) {
        Filter<F> filter = new Filter<F>();
        filter.setSsf(instance.ssf);
        if (this.m_initializer != null) {
            filter.setInitializer(this.m_initializer);
        }
        DiffusePredictionErrorDecomposition pred = new DiffusePredictionErrorDecomposition(true);
        if (filter.process(instance.getData(), pred)) {
            return this.calcLikelihood(pred);
        }
        return null;
    }

    private DefaultLikelihoodEvaluation<DiffuseConcentratedLikelihood> calcRegs(SsfModel<F> instance) {
        Filter<F> filter = new Filter<F>();
        filter.setSsf(instance.ssf);
        if (this.m_initializer != null) {
            filter.setInitializer(this.m_initializer);
        }
        DiffuseFilteringResults drslts = new DiffuseFilteringResults(true);
        if (!filter.process(instance.getData(), drslts)) {
            return null;
        }
        return this.calcLikelihood(instance, drslts);
    }

    @Override
    public DefaultLikelihoodEvaluation<DiffuseConcentratedLikelihood> evaluate(SsfModel<F> instance) {
        if (instance.getX() == null) {
            return this.calcNoRegs(instance);
        }
        return this.calcRegs(instance);
    }
}

