/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.Utilities;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.arima.IModelEstimator;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.x13.IGlsEstimator;
import ec.tstoolkit.modelling.arima.x13.X13Preprocessor;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;

public class IGlsFinalEstimator
implements IModelEstimator {
    private double cancel_ = 0.1;
    private double tsig_ = 1.0;
    private double ur_ = 0.94;
    private static final int MAXD = 2;
    private static final int MAXBD = 1;
    private double eps_ = 1.0E-5;

    public double getEpsilon() {
        return this.eps_;
    }

    public void setEpsilon(double val) {
        this.eps_ = val;
    }

    @Override
    public boolean estimate(ModellingContext context) {
        int niter = 0;
        do {
            try {
                IParametricMapping<SarimaModel> mapping = X13Preprocessor.createDefaultMapping(context.description);
                IGlsEstimator monitor = new IGlsEstimator(mapping);
                monitor.setPrecision(this.eps_);
                ModelDescription model = context.description;
                context.estimation = new ModelEstimation(model.buildRegArima(), model.getLikelihoodCorrection());
                int ndim = mapping.getDim();
                context.estimation.compute(monitor, ndim);
                context.estimation.updateParametersCovariance(monitor.getParametersCovariance());
                if (ndim == 0) {
                    return true;
                }
                if (context.automodelling) {
                    int itest = this.test(context);
                    if (itest == 0) {
                        return true;
                    }
                    if (itest > 1) {
                        return false;
                    }
                    continue;
                }
                return true;
            }
            catch (RuntimeException err) {
                return false;
            }
        } while (niter++ < 5);
        return false;
    }

    private int test(ModellingContext context) {
        int nnsig;
        double t;
        double s;
        double v;
        double cval = this.tsig_;
        int nz = context.description.getEstimationDomain().getLength();
        double cmin = nz <= 150 ? 0.15 : 0.1;
        double cmod = 0.95;
        double bmin = 999.0;
        SarimaModel m = context.estimation.getRegArima().getArima();
        SarimaSpecification spec = m.getSpecification();
        if (spec.getParametersCount() == 1) {
            return 0;
        }
        IReadDataBlock pm = m.getParameters();
        int start = 0;
        int len = spec.getP();
        boolean dpr = Utilities.checkRoots(pm.rextract(start, len), 1.0 / cmod);
        start += len;
        len = spec.getBP();
        boolean dps = Utilities.checkRoots(pm.rextract(start, len), 1.0 / cmod);
        start += len;
        len = spec.getQ();
        boolean dqr = Utilities.checkRoots(pm.rextract(start, len), 1.0 / cmod);
        start += len;
        len = spec.getBQ();
        boolean dqs = Utilities.checkRoots(pm.rextract(start, len), 1.0 / cmod);
        if (!(dpr || dps || dqr || dqs)) {
            return 0;
        }
        int cpr = 0;
        int cps = 0;
        int cqr = 0;
        int cqs = 0;
        double tmin = cval;
        DataBlock diag = context.estimation.getParametersCovariance().diagonal();
        int k = -1;
        if (dpr) {
            v = Math.abs(pm.get(k += spec.getP()));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin) {
                ++cpr;
                bmin = t;
            }
        }
        if (dps) {
            v = Math.abs(pm.get(k += spec.getBP()));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin && bmin > t) {
                ++cps;
                bmin = t;
                cpr = 0;
            }
        }
        if (dqs) {
            v = Math.abs(pm.get(k += spec.getQ()));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin && bmin > t) {
                ++cqr;
                bmin = t;
                cpr = 0;
                cps = 0;
            }
        }
        if (dqs) {
            v = Math.abs(pm.get(k += spec.getBQ()));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin && bmin > t) {
                ++cqs;
                cpr = 0;
                cps = 0;
                cqr = 0;
            }
        }
        if ((nnsig = cpr + cps + cqr + cqs) == 0) {
            return 0;
        }
        SarimaSpecification nspec = spec.clone();
        context.estimation = null;
        if (cpr > 0) {
            nspec.setP(nspec.getP() - cpr);
        } else if (cps > 0) {
            nspec.setBP(nspec.getBP() - cps);
        } else if (cqr > 0) {
            nspec.setQ(nspec.getQ() - cqr);
        } else if (cqs > 0) {
            nspec.setBQ(nspec.getBQ() - cqs);
        }
        context.description.setSpecification(nspec);
        return nnsig;
    }

    private int searchur(Complex[] r) {
        if (r == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < r.length; ++i) {
            double cdim = Math.abs(r[i].getIm());
            double vcur = r[i].abs();
            if (!(vcur > this.ur_) || !(cdim <= 0.05) || !(r[i].getRe() > 0.0)) continue;
            ++n;
        }
        return n;
    }
}

