/*
 * Decompiled with CFR 0.152.
 */
package com.nexr.rhive.util;

import java.util.Comparator;
import java.util.TreeMap;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class RangeTreeFactory {
    public static RangeTree createStringTree(String name, boolean minExclusive, boolean maxExclusive, Object defaultValue) {
        StringRangeComparator scomp = new StringRangeComparator(minExclusive, maxExclusive);
        return new StringRangeTree<Object>(name, scomp, defaultValue);
    }

    public static RangeTree createDoubleTree(String name, boolean minExclusive, boolean maxExclusive, Object defaultValue) {
        DoubleRangeComparator dcomp = new DoubleRangeComparator(minExclusive, maxExclusive);
        return new DoubleRangeTree<Object>(name, dcomp, defaultValue);
    }

    public static RangeTree createFloatTree(String name, boolean minExclusive, boolean maxExclusive, Object defaultValue) {
        FloatRangeComparator dcomp = new FloatRangeComparator(minExclusive, maxExclusive);
        return new FloatRangeTree<Object>(name, dcomp, defaultValue);
    }

    public static RangeTree createLongTree(String name, boolean minExclusive, boolean maxExclusive, Object defaultValue) {
        LongRangeComparator lcomp = new LongRangeComparator(minExclusive, maxExclusive);
        return new LongRangeTree<Object>(name, lcomp, defaultValue);
    }

    public static RangeTree createIntTree(String name, boolean minExclusive, boolean maxExclusive, Object defaultValue) {
        IntRangeComparator icomp = new IntRangeComparator(minExclusive, maxExclusive);
        return new IntRangeTree<Object>(name, icomp, defaultValue);
    }

    private static class FloatRangeComparator
    implements Comparator<float[]> {
        final boolean minExclusive;
        final boolean maxExclusive;

        public FloatRangeComparator(boolean minExclusive, boolean maxExclusive) {
            this.minExclusive = minExclusive;
            this.maxExclusive = maxExclusive;
        }

        @Override
        public int compare(float[] o1, float[] o2) {
            int maxCompared;
            int minCompared;
            int n = o1[0] < o2[0] ? -1 : (minCompared = o1[0] == o2[0] ? 0 : 1);
            if (minCompared <= 0) {
                return minCompared == 0 && this.minExclusive ? -1 : minCompared;
            }
            int n2 = o1[1] < o2[1] ? -1 : (maxCompared = o1[1] == o2[1] ? 0 : 1);
            if (maxCompared <= 0) {
                return maxCompared == 0 && this.maxExclusive ? 1 : 0;
            }
            return maxCompared;
        }
    }

    private static class DoubleRangeComparator
    implements Comparator<double[]> {
        final boolean minExclusive;
        final boolean maxExclusive;

        public DoubleRangeComparator(boolean minExclusive, boolean maxExclusive) {
            this.minExclusive = minExclusive;
            this.maxExclusive = maxExclusive;
        }

        @Override
        public int compare(double[] o1, double[] o2) {
            int maxCompared;
            int minCompared;
            int n = o1[0] < o2[0] ? -1 : (minCompared = o1[0] == o2[0] ? 0 : 1);
            if (minCompared <= 0) {
                return minCompared == 0 && this.minExclusive ? -1 : minCompared;
            }
            int n2 = o1[1] < o2[1] ? -1 : (maxCompared = o1[1] == o2[1] ? 0 : 1);
            if (maxCompared <= 0) {
                return maxCompared == 0 && this.maxExclusive ? 1 : 0;
            }
            return maxCompared;
        }
    }

    private static class LongRangeComparator
    implements Comparator<long[]> {
        final boolean minExclusive;
        final boolean maxExclusive;

        public LongRangeComparator(boolean minExclusive, boolean maxExclusive) {
            this.minExclusive = minExclusive;
            this.maxExclusive = maxExclusive;
        }

        @Override
        public int compare(long[] o1, long[] o2) {
            int maxCompared;
            int minCompared;
            int n = o1[0] < o2[0] ? -1 : (minCompared = o1[0] == o2[0] ? 0 : 1);
            if (minCompared <= 0) {
                return minCompared == 0 && this.minExclusive ? -1 : minCompared;
            }
            int n2 = o1[1] < o2[1] ? -1 : (maxCompared = o1[1] == o2[1] ? 0 : 1);
            if (maxCompared <= 0) {
                return maxCompared == 0 && this.maxExclusive ? 1 : 0;
            }
            return maxCompared;
        }
    }

    private static class IntRangeComparator
    implements Comparator<int[]> {
        final boolean minExclusive;
        final boolean maxExclusive;

        public IntRangeComparator(boolean minExclusive, boolean maxExclusive) {
            this.minExclusive = minExclusive;
            this.maxExclusive = maxExclusive;
        }

        @Override
        public int compare(int[] o1, int[] o2) {
            int maxCompared;
            int minCompared;
            int n = o1[0] < o2[0] ? -1 : (minCompared = o1[0] == o2[0] ? 0 : 1);
            if (minCompared <= 0) {
                return minCompared == 0 && this.minExclusive ? -1 : minCompared;
            }
            int n2 = o1[1] < o2[1] ? -1 : (maxCompared = o1[1] == o2[1] ? 0 : 1);
            if (maxCompared <= 0) {
                return maxCompared == 0 && this.maxExclusive ? 1 : 0;
            }
            return maxCompared;
        }
    }

    private static class StringRangeComparator
    implements Comparator<String[]> {
        final boolean minExclusive;
        final boolean maxExclusive;

        public StringRangeComparator(boolean minExclusive, boolean maxExclusive) {
            this.minExclusive = minExclusive;
            this.maxExclusive = maxExclusive;
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            int minCompared = o1[0].compareTo(o2[0]);
            if (minCompared <= 0) {
                return minCompared == 0 && this.minExclusive ? -1 : minCompared;
            }
            int maxCompared = o1[1].compareTo(o2[1]);
            if (maxCompared <= 0) {
                return maxCompared == 0 && this.maxExclusive ? 1 : 0;
            }
            return maxCompared;
        }
    }

    public static class FloatRangeTree<V>
    extends RangeTree<float[], V> {
        FloatRangeTree(String name, Comparator<float[]> comparator, V defaultValue) {
            super(name, comparator, defaultValue);
        }

        public V search(float value) {
            return this.get(new float[]{value, value});
        }

        public Writable searchWritable(float value) {
            return this.convertWritable(this.search(value));
        }
    }

    public static class DoubleRangeTree<V>
    extends RangeTree<double[], V> {
        DoubleRangeTree(String name, Comparator<double[]> comparator, V defaultValue) {
            super(name, comparator, defaultValue);
        }

        public V search(double value) {
            return this.get(new double[]{value, value});
        }

        public Writable searchWritable(double value) {
            return this.convertWritable(this.search(value));
        }
    }

    public static class LongRangeTree<V>
    extends RangeTree<long[], V> {
        LongRangeTree(String name, Comparator<long[]> comparator, V defaultValue) {
            super(name, comparator, defaultValue);
        }

        public V search(long value) {
            return this.get(new long[]{value, value});
        }

        public Writable searchWritable(long value) {
            return this.convertWritable(this.search(value));
        }
    }

    public static class IntRangeTree<V>
    extends RangeTree<int[], V> {
        IntRangeTree(String name, Comparator<int[]> comparator, V defaultValue) {
            super(name, comparator, defaultValue);
        }

        public V search(int value) {
            return this.get(new int[]{value, value});
        }

        public Writable searchWritable(int value) {
            return this.convertWritable(this.search(value));
        }
    }

    public static class StringRangeTree<V>
    extends RangeTree<String[], V> {
        StringRangeTree(String name, Comparator<String[]> comparator, V defaultValue) {
            super(name, comparator, defaultValue);
        }

        public V search(String value) {
            return this.get(new String[]{value, value});
        }

        public Writable searchWritable(String value) {
            return this.convertWritable(this.search(value));
        }
    }

    public static abstract class RangeTree<T, V>
    extends TreeMap<T, V> {
        private final String name;
        private final V defaultValue;

        RangeTree(String name, Comparator<T> comparator, V defaultValue) {
            super(comparator);
            this.name = name;
            this.defaultValue = defaultValue;
        }

        @Override
        public V get(Object key) {
            Object result = super.get(key);
            return result == null ? this.defaultValue : result;
        }

        public String getName() {
            return this.name;
        }

        public Writable convertWritable(Object obj) {
            if (obj == null) {
                return null;
            }
            Object w = null;
            w = obj instanceof Integer ? new IntWritable(((Integer)obj).intValue()) : (obj instanceof Long ? new LongWritable(((Long)obj).longValue()) : (obj instanceof Double ? new DoubleWritable(((Double)obj).doubleValue()) : new Text(obj.toString())));
            return w;
        }
    }
}

