/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionCursor;
import org.h2.index.TreeIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiVersionIndex
implements Index {
    private final Index base;
    private final TreeIndex delta;
    private final RegularTable table;
    private final Object sync;
    private final Column firstColumn;

    public MultiVersionIndex(Index index, RegularTable regularTable) {
        this.base = index;
        this.table = regularTable;
        IndexType indexType = IndexType.createNonUnique(false);
        this.delta = new TreeIndex(regularTable, -1, "DELTA", index.getIndexColumns(), indexType);
        this.delta.setMultiVersion(true);
        this.sync = index.getDatabase();
        this.firstColumn = index.getColumns()[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session, Row row) {
        Object object = this.sync;
        synchronized (object) {
            this.base.add(session, row);
            if (!this.removeIfExists(session, row) && row.getSessionId() != 0) {
                this.delta.add(session, row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Session session) {
        Object object = this.sync;
        synchronized (object) {
            this.base.close(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor find(TableFilter tableFilter, SearchRow searchRow, SearchRow searchRow2) {
        Object object = this.sync;
        synchronized (object) {
            Cursor cursor = this.base.find(tableFilter, searchRow, searchRow2);
            Cursor cursor2 = this.delta.find(tableFilter, searchRow, searchRow2);
            return new MultiVersionCursor(tableFilter.getSession(), this, cursor, cursor2, this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        Object object = this.sync;
        synchronized (object) {
            Cursor cursor = this.base.find(session, searchRow, searchRow2);
            Cursor cursor2 = this.delta.find(session, searchRow, searchRow2);
            return new MultiVersionCursor(session, this, cursor, cursor2, this.sync);
        }
    }

    @Override
    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        throw DbException.throwInternalError();
    }

    @Override
    public boolean canFindNext() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return this.base.canGetFirstOrLast() && this.delta.canGetFirstOrLast();
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        SearchRow searchRow;
        if (bl) {
            Cursor cursor = this.find(session, null, null);
            while (cursor.next()) {
                SearchRow searchRow2 = cursor.getSearchRow();
                Value value = searchRow2.getValue(this.firstColumn.getColumnId());
                if (value == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        Cursor cursor = this.base.findFirstOrLast(session, false);
        Cursor cursor2 = this.delta.findFirstOrLast(session, false);
        MultiVersionCursor multiVersionCursor = new MultiVersionCursor(session, this, cursor, cursor2, this.sync);
        multiVersionCursor.loadCurrent();
        while (multiVersionCursor.previous() && (searchRow = multiVersionCursor.getSearchRow()) != null) {
            Value value = searchRow.getValue(this.firstColumn.getColumnId());
            if (value == ValueNull.INSTANCE) continue;
            return multiVersionCursor;
        }
        return multiVersionCursor;
    }

    @Override
    public double getCost(Session session, int[] nArray) {
        return this.base.getCost(session, nArray);
    }

    @Override
    public boolean needRebuild() {
        return this.base.needRebuild();
    }

    public boolean isUncommittedFromOtherSession(Session session, Row row) {
        Cursor cursor = this.delta.find(session, (SearchRow)row, (SearchRow)row);
        if (cursor.next()) {
            Row row2 = cursor.get();
            return row2.getSessionId() != session.getId();
        }
        return false;
    }

    private boolean removeIfExists(Session session, Row row) {
        Cursor cursor = this.delta.find(session, (SearchRow)row, (SearchRow)row);
        while (cursor.next()) {
            Row row2 = cursor.get();
            if (row2.getKey() != row.getKey() || row2.getVersion() != row.getVersion()) continue;
            if (row2 != row && this.table.getScanIndex(session).compareRows(row2, row) != 0) {
                row.setVersion(row2.getVersion() + 1);
                continue;
            }
            this.delta.remove(session, row2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Session session, Row row) {
        Object object = this.sync;
        synchronized (object) {
            this.base.remove(session, row);
            if (!this.removeIfExists(session, row)) {
                this.delta.add(session, row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Session session) {
        Object object = this.sync;
        synchronized (object) {
            this.base.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(Session session) {
        Object object = this.sync;
        synchronized (object) {
            this.delta.truncate(session);
            this.base.truncate(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(int n, Row row) {
        Object object = this.sync;
        synchronized (object) {
            this.removeIfExists(null, row);
        }
    }

    @Override
    public int compareRows(SearchRow searchRow, SearchRow searchRow2) {
        return this.base.compareRows(searchRow, searchRow2);
    }

    @Override
    public int getColumnIndex(Column column) {
        return this.base.getColumnIndex(column);
    }

    @Override
    public Column[] getColumns() {
        return this.base.getColumns();
    }

    @Override
    public IndexColumn[] getIndexColumns() {
        return this.base.getIndexColumns();
    }

    @Override
    public String getCreateSQL() {
        return this.base.getCreateSQL();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        return this.base.getCreateSQLForCopy(table, string);
    }

    @Override
    public String getDropSQL() {
        return this.base.getDropSQL();
    }

    @Override
    public IndexType getIndexType() {
        return this.base.getIndexType();
    }

    @Override
    public String getPlanSQL() {
        return this.base.getPlanSQL();
    }

    @Override
    public long getRowCount(Session session) {
        return this.base.getRowCount(session);
    }

    @Override
    public Table getTable() {
        return this.base.getTable();
    }

    @Override
    public int getType() {
        return this.base.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChildrenAndResources(Session session) {
        Object object = this.sync;
        synchronized (object) {
            this.table.removeIndex(this);
            this.remove(session);
        }
    }

    @Override
    public String getSQL() {
        return this.base.getSQL();
    }

    @Override
    public Schema getSchema() {
        return this.base.getSchema();
    }

    @Override
    public void checkRename() {
        this.base.checkRename();
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        return this.base.getChildren();
    }

    @Override
    public String getComment() {
        return this.base.getComment();
    }

    @Override
    public Database getDatabase() {
        return this.base.getDatabase();
    }

    @Override
    public int getId() {
        return this.base.getId();
    }

    @Override
    public String getName() {
        return this.base.getName();
    }

    @Override
    public boolean isTemporary() {
        return this.base.isTemporary();
    }

    @Override
    public void rename(String string) {
        this.base.rename(string);
    }

    @Override
    public void setComment(String string) {
        this.base.setComment(string);
    }

    @Override
    public void setTemporary(boolean bl) {
        this.base.setTemporary(bl);
    }

    @Override
    public long getRowCountApproximation() {
        return this.base.getRowCountApproximation();
    }

    public Index getBaseIndex() {
        return this.base;
    }

    @Override
    public Row getRow(Session session, long l) {
        return this.base.getRow(session, l);
    }

    @Override
    public boolean isHidden() {
        return this.base.isHidden();
    }

    @Override
    public boolean isRowIdIndex() {
        return this.base.isRowIdIndex() && this.delta.isRowIdIndex();
    }

    @Override
    public boolean canScan() {
        return this.base.canScan();
    }

    @Override
    public void setSortedInsertMode(boolean bl) {
        this.base.setSortedInsertMode(bl);
        this.delta.setSortedInsertMode(bl);
    }
}

