% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/senDownSearch.R
\name{senDownSearch}
\alias{senDownSearch}
\title{Download Sentinel images from a search list}
\usage{
senDownSearch(searchres, AppRoot, username = NULL, password = NULL,
  nattempts = 5, unzip = FALSE, overwrite = FALSE, ...)
}
\arguments{
\item{searchres}{the output from the \code{\link{senSearch}} function.}

\item{AppRoot}{the directory where the outcoming time series are saved.}

\item{username}{ESA’s `SciHub' username.}

\item{password}{ESA’s `SciHub' password.}

\item{nattempts}{the number of attempts to download an image in case it
becomes corrupted.}

\item{unzip}{logical argument. If \code{TRUE}, unzips the images.}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{...}{arguments for nested functions.}
}
\description{
\code{senDownSearch} downloads the images from a list of uniform resource
locators (URLs) generated by the \code{\link{senSearch}} function from ESA’s
`SciHub' web service. The images are saved as GTiff files in the \code{AppRoot}
directory.
}
\details{
\code{senDownSearch} downloads the list of URLs provided by 
\code{\link{senSearch}}. In case the process is interrupted, the image file
could be corrupted. The function detects the corrupted files and restarts the
process. To prevent the computer from crashing, there is a maximum number of
attempts to try to donwnload the image (\code{nattempts}). The default number
of attempts is set to 3. The function requires an ESA’s `SciHub' account, which
can be obtained 
\href{https://scihub.copernicus.eu/dhus/#/self-registration}{here}.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
# download S2MSI1C products sensed by Sentinel-2
# in July-August 2018
searchres <- senSearch(startDate = as.Date("2018-07-29","\%Y-\%m-\%d"),
                       endDate = as.Date("2018-08-06","\%Y-\%m-\%d"),
                       platform = "Sentinel-2",
                       extent = ex.navarre,
                       product = "S2MSI1C",
                       username = "username",
                       password = "password")

# filtering the path R094 where Navarre is located
names(searchres)
searchres.R094 <- searchres[grepl("R094", names(searchres))]
names(searchres.R094)
# list the dates in searchres
senGetDates(names(searchres.R094),format="\%Y\%j")
src <- paste0(tempdir(),"/Path_for_downloading_folder")
# donwload the imagery
senDownSearch(searchres = searchres.R094,
              username = "username",
              password = "password",
              AppRoot = src,
              unzip = TRUE)
src.unzip <- file.path(src,"unzip")
files<-list.files(src.unzip,
                  pattern = "\\\\TCI.jp2$",
                  full.names = TRUE,
                  recursive = TRUE)
rgb<-stack(files[1])
plotRGB(rgb)
}
}
