% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genMissionGetDates.R
\name{lsGetDates}
\alias{lsGetDates}
\title{Return the capturing dates of Landsat-7 or Landsat-8 images}
\usage{
lsGetDates(str, ...)
}
\arguments{
\item{str}{the full path(s) or official name(s) of the Landsat-7 or
Landsat-8 images from which the capturing date is retrieved.}

\item{...}{arguments for nested functions:
\itemize{
  \item \code{format} the format of the date being returned.
}}
}
\description{
\code{lsGetDates} reads the official name of a Landsat-7 or Landsat-8 image
and returns the capturing date, as a \code{Date} class object.
}
\details{
The function works with file names (or their paths) regardless of their
extension. The function accepts more than on file path, which can be passed
as a \code{character} vector. Dates are returned as `\code{YYYY-mm-dd}' by
default. If another format is required, it can be modified through the 
argument \code{format}.
}
\examples{
# getting the capturing date from the name of a Landsat-8 image
str <- "LC82000312017010LGN01.tar.gz"
dt <- lsGetDates(str)
print(dt)
print(format(dt, "\%Y\%j"))

# getting the capturing date from the name of a Landsat-7 and a Landsat-8
# image
str <- c("LE72330822017009ASN01")
dt <- lsGetDates(str)
print(dt)

}
