% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rgcca.R, R/plot.rgcca_cv.R,
%   R/plot.rgcca_permutation.R, R/plot.rgcca_bootstrap.r,
%   R/plot.rgcca_stability.R
\name{plot.rgcca}
\alias{plot.rgcca}
\alias{plot.rgcca_cv}
\alias{plot.rgcca_permutation}
\alias{plot.rgcca_bootstrap}
\alias{plot.rgcca_stability}
\title{Plot a fitted object from the RGCCA package}
\usage{
\method{plot}{rgcca}(
  x,
  type = "weights",
  block = seq_along(x$call$blocks),
  comp = c(1, 2),
  response = as.factor(rep(1, NROW(x$Y[[1]]))),
  display_order = TRUE,
  title = NULL,
  cex = 1,
  cex_sub = 12 * cex,
  cex_main = 14 * cex,
  cex_lab = 12 * cex,
  cex_point = 3 * cex,
  n_mark = 30,
  sample_colors = NULL,
  sample_shapes = NULL,
  var_colors = NULL,
  var_shapes = NULL,
  AVE_colors = NULL,
  show_sample_names = TRUE,
  show_var_names = TRUE,
  repel = FALSE,
  display_blocks = seq_along(x$call$blocks),
  expand = 1,
  show_arrows = TRUE,
  ...
)

\method{plot}{rgcca_cv}(
  x,
  type = c("sd", "quantile"),
  cex = 1,
  cex_main = 14 * cex,
  cex_sub = 12 * cex,
  cex_point = 3 * cex,
  cex_lab = 12 * cex,
  display_order = TRUE,
  ...
)

\method{plot}{rgcca_permutation}(
  x,
  type = c("crit", "zstat"),
  cex = 1,
  title = NULL,
  cex_main = 14 * cex,
  cex_sub = 12 * cex,
  cex_point = 3 * cex,
  cex_lab = 12 * cex,
  display_order = TRUE,
  show_legend = FALSE,
  ...
)

\method{plot}{rgcca_bootstrap}(
  x,
  block = seq_along(x$rgcca$call$blocks),
  comp = 1,
  type = c("weights", "loadings"),
  empirical = TRUE,
  n_mark = 30,
  display_order = TRUE,
  show_stars = TRUE,
  title = NULL,
  cex = 1,
  cex_sub = 12 * cex,
  cex_main = 14 * cex,
  cex_lab = 12 * cex,
  cex_point = 3 * cex,
  colors = NULL,
  adj.method = "fdr",
  ...
)

\method{plot}{rgcca_stability}(x, ...)
}
\arguments{
\item{x}{An object to be plotted (output of functions \code{\link{rgcca}},
\code{\link{rgcca_cv}}, \code{\link{rgcca_permutation}},
\code{\link{rgcca_bootstrap}}, or \code{\link{rgcca_stability}}).}

\item{type}{A character string indicating the type of plot (see details).}

\item{block}{A numeric corresponding to the block(s) to plot.}

\item{comp}{A numeric vector indicating the component(s) to consider.}

\item{response}{A vector coloring the points in the "samples" plot.}

\item{display_order}{A logical value for ordering the variables. If TRUE,
variables are ordered from highest to lowest absolute value. If FALSE,
the block order is used. Default is TRUE.}

\item{title}{A string specifying the title of the plot.}

\item{cex}{A numeric defining the size of the objects in the plot. Default
is one.}

\item{cex_sub}{A numeric defining the font size of the subtitle. Default is
12 * cex.}

\item{cex_main}{A numeric defining the font size of the title. Default is
14 * cex.}

\item{cex_lab}{A numeric defining the font size of the labels. Default is
12 * cex.}

\item{cex_point}{A numeric defining the font size of the points. Default is
3 * cex.}

\item{n_mark}{An integer defining the maximum number plotted objects
(see details).}

\item{sample_colors}{A string specifying the colors used to color samples
(used in the "samples" and "biplot" plots).}

\item{sample_shapes}{Shapes used for the sample points (used in the "samples"
and "biplot" plots).}

\item{var_colors}{Colors used to color variable weights or correlations
with canonical components (used in the "weights", "loadings", "cor_circle"
and "biplot" plots).}

\item{var_shapes}{Shapes used for the points associated to variable weights
or correlations with canonical components (used in the "cor_circle" and
"biplot" plots).}

\item{AVE_colors}{Colors used in the AVE plot.}

\item{show_sample_names}{A logical value for showing the sample names in
plots "samples" and "biplot".}

\item{show_var_names}{A logical value for showing the variable names in
plots "cor_circle" and "biplot".}

\item{repel}{A logical value for repelling text labels from each other.
Default to FALSE.}

\item{display_blocks}{A numeric corresponding to the block(s) to display in
the correlation_circle. All blocks are displayed by default.}

\item{expand}{A numeric that scales the weights associated to the block
variables in the biplot. Default is 1.}

\item{show_arrows}{A logical, if TRUE, arrows are shown in the biplot.
Default is FALSE.}

\item{...}{Additional graphical parameters.}

\item{show_legend}{A logical value indicating if legend should
be shown (default is FALSE).}

\item{empirical}{A logical value indicating if the bootstrap confidence
intervals and p-values are derived from the empirical distribution.
(default: TRUE)}

\item{show_stars}{A logical value indicating if the significance levels
are displayed.}

\item{colors}{Colors used in the plots.}

\item{adj.method}{A string indicating the method used to adjust the p-values.
It must be a method handled by the p.adjust function. Default is "fdr".}
}
\value{
A ggplot2 plot object.
}
\description{
`plot.rgcca()` plots a fitted RGCCA object.

`plot.rgcca_cv()` plots a fitted rgcca_cv object. Boxplots of the
cross-validated scores for the different parameter sets are displayed.

`plot.rgcca_permutation()` plots a fitted rgcca_permutation object.
Permutation statistics are displayed for each set of parameters.

`plot.rgcca_bootstrap()` plots a fitted rgcca_bootstrap object.
Each block variable is shown along with its associated bootstrap
confidence interval and stars reflecting the p-value of assigning
a strictly positive or negative weight to this block variable.

`plot.rgcca_stability()` calls `plot.rgcca()` on the fitted RGCCA model
returned by `rgcca_stability()`.
}
\details{
Argument type can take 7 values in `plot.rgcca`:
\itemize{
\item "weights" (default): barplot of the block weight vectors for one
specific block/component. Sorting is applied according to the
display_order argument. The number of displayed weights can be set with
n_marks.
\item "loadings": barplot of the block-loading vectors. Sorting is applied
according to the display_order argument. The number of displayed loadings
can be set with n_marks.
\item "samples": scatter plot of the block components. The blocks used
are defined by the block argument, and the components by the comp argument
(Y[[block[1]]][, comp[1]], Y[[block[2]]][,comp[2]]). Points can
be colored according to the response argument.
\item  "cor_circle" for correlation circle. It represents the correlation
between the block component corresponding to the first element of the block
argument, and the variables of the block corresponding to the blocks
specified by the argument display_blocks.
\item "both": displays both sample plot and correlation circle (implemented
only for one block and at least when two components are extracted
(ncomp >= 2).
\item "biplot": displays on the same plot the scatter plot of the block
components and the variables used to compute these block components.
\item "ave": displays the average variance explained for each block.}

Argument type can take 2 values in `plot.rgcca_cv`: \itemize{
\item "sd" (default): the middle bar of the boxplots corresponds to the
mean and their limits are given by the mean plus or minus the
standard deviation.
\item "quantile": the middle bar corresponds to the median and limits of
the boxes are given by the 25\% and 75\% quantiles.
}

Argument type can take 2 values in `plot.rgcca_permutation`: \itemize{
\item "crit" (default): both the RGCCA criterion on the permuted and not
permuted datasets are displayed for each set of parameters.
\item "zstat": the Z-score is displayed for each set of parameters.
}

Argument type can take 2 values in `plot.rgcca_bootstrap`: \itemize{
\item "weights" (default): statistics about the block-weight
vectors are displayed.
\item "loadings": statistics about the block-loading vectors are displayed.
}
}
\examples{
## Plotting of an rgcca object
data("Russett")
blocks <- list(
  agriculture = Russett[, seq(3)],
  industry = Russett[, 4:5],
  politic = as.factor(apply(Russett[, 9:11], 1, which.max))
)
blocks2 <- list(
  agriculture = Russett[, seq(3)],
  industry = Russett[, 4:5],
  politic = Russett[, 6:11]
)
status <- colnames(Russett)[9:11][apply(Russett[, 9:11], 1, which.max)]
fit_rgcca <- rgcca(blocks = blocks, response = 3, ncomp = 2)

plot(fit_rgcca, type = "sample", block = 1:2, comp = 1)
plot(fit_rgcca, type = "loadings")
plot(fit_rgcca, type = "weight")
plot(fit_rgcca, type = "sample")
plot(fit_rgcca, type = "cor_circle")
plot(fit_rgcca, type = "both")
plot(fit_rgcca, type = "biplot")
plot(fit_rgcca, type = "ave")

\dontrun{
# With a superblock
fit_mcoa <- rgcca(blocks = blocks2, method = "mcoa", ncomp = 2)

plot(fit_mcoa, type = "both", response = status)
plot(fit_mcoa, type = "biplot", response = status)

## Plotting of an rgcca_cv object
cv_out <- rgcca_cv(blocks,
  response = 3, method = "rgcca",
  par_type = "tau",
  par_value = 1,
  n_run = 1, n_cores = 1,
  prediction_model = "lda",
  metric = "Accuracy",
  verbose = TRUE
)

plot(cv_out, type = "sd")
plot(cv_out, type = "quantile")

## Ploting of an rgcca_permutation object
perm_out <- rgcca_permutation(blocks2, par_type = "tau",
                              n_perms = 2, n_cores = 1)

plot(perm_out, type = "crit")
plot(perm_out, type = "zstat")

## Plotting of an rgcca_bootstrap object
boot_out <- rgcca_bootstrap(fit_rgcca, n_boot = 20, n_cores = 1)
plot(boot_out, type = "weights", block = 1, comp = 1)
plot(boot_out, type = "loadings", comp = 2,
     display_order = FALSE, show_stars = FALSE)

## Plotting of an rgcca_stability object
fit.sgcca <- rgcca(blocks2, sparsity = c(.8, .9, .6))
res <- rgcca_stability(
  fit.sgcca, n_boot = 10, verbose = TRUE, keep = rep(.1, 3)
)

plot(res, type = "samples")
}

}
