/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.view.AbstractView;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.UpdateManager;
import freak.module.searchspace.BooleanFunction;
import freak.module.searchspace.BooleanFunctionGenotype;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ParetoFront
extends AbstractView
implements Configurable,
FreakSwingModel {
    private transient JPanel panel;
    private static final float MAXIMAL_HUE = 0.8f;
    private static float SATURATION = 1.0f;
    private static float BRIGHTNESS = 1.0f;
    private static Color DEFAULT_COLOR = Color.red;
    private IndividualList individuals;
    private boolean colorByFitness;
    private boolean displayOptimum = this.supportsDisplayOptimum();
    private int maximalNumberOfIndividuals = 1000;
    int counter = 1;

    public ParetoFront(Schedule schedule) {
        super(schedule);
        this.colorByFitness = this.supportsUseColor();
    }

    public void initialize() {
        super.initialize();
        this.displayOptimum &= this.supportsDisplayOptimum();
        this.colorByFitness &= this.supportsUseColor();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getGenotypeSearchSpace() instanceof BooleanFunction)) {
            throw new UnsupportedEnvironmentException("Unsupported searchspace.");
        }
    }

    public JPanel createPanel() {
        this.panel = new ParetoViewPanel(this);
        return this.panel;
    }

    private boolean supportsUseColor() {
        if (!(this.getSchedule().getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            return false;
        }
        SingleObjectiveFitnessFunction fitness = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
        try {
            fitness.getLowerBound();
            fitness.getUpperBound();
            return true;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    private boolean supportsDisplayOptimum() {
        FitnessFunction fitness = this.getSchedule().getFitnessFunction();
        try {
            fitness.getGenotypeOptimum();
            return true;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object data) {
        int wert;
        int generation = this.schedule.getCurrentGeneration();
        if (generation == (wert = 10 * this.counter) | generation == 1) {
            super.update(data);
            ParetoFront paretoFront = this;
            synchronized (paretoFront) {
                this.individuals = (IndividualList)data;
            }
            UpdateManager.markDirty(this);
            ++this.counter;
        }
    }

    public void flush() {
        if (this.panel == null) {
            return;
        }
        this.panel.repaint();
    }

    public String getName() {
        return "Pareto Front";
    }

    public String getDescription() {
        return "Computes the Pareto Front.";
    }

    public Class[] getInputDataTypes() {
        return new Class[]{IndividualList.class};
    }

    public Color getColorByFitness(Individual individual) {
        if (!this.colorByFitness) {
            return DEFAULT_COLOR;
        }
        try {
            SingleObjectiveFitnessFunction fitness = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
            double lowerFitnessBound = fitness.getLowerBound();
            double upperFitnessBound = fitness.getUpperBound();
            double fitnessValue = fitness.evaluate(individual, this.individuals);
            double normalizedFitnessValue = (fitnessValue - lowerFitnessBound) / (upperFitnessBound - lowerFitnessBound);
            Color result = new Color(Color.HSBtoRGB((float)(1.0 - normalizedFitnessValue) * 0.8f, SATURATION, BRIGHTNESS));
            return result;
        }
        catch (UnsupportedOperationException ex) {
            return DEFAULT_COLOR;
        }
    }

    public IndividualList getIndividualList() {
        return this.individuals;
    }

    public void setPropertyColorByFitness(Boolean colorByFitness) {
        this.colorByFitness = colorByFitness != false && this.supportsUseColor();
    }

    public Boolean getPropertyColorByFitness() {
        return new Boolean(this.colorByFitness);
    }

    public String getShortDescriptionForColorByFitness() {
        return "Color individuals by fitness";
    }

    public String getLongDescriptionForColorByFitness() {
        return "Colors the displayed individuals by their fitness on a scale from violet (least fitness) to red (highest fitness). This feature can only be enabled if the fitness function knows the optimal fitness value.";
    }

    public void setPropertyDisplayOptimum(Boolean displayOptimum) {
        this.displayOptimum = displayOptimum != false && this.supportsDisplayOptimum();
    }

    public Boolean getPropertyDisplayOptimum() {
        return new Boolean(this.displayOptimum);
    }

    public String getShortDescriptionForDisplayOptimum() {
        return "Display global optimum";
    }

    public String getLongDescriptionForDisplayOptimum() {
        return "Displays the global optimum in the ParetoView. This option can only be enabled if a global optimum exists and if the fitness function knows the optimum.";
    }

    public void setPropertyMaximalNumberOfIndividuals(Integer number) {
        if (number > 0) {
            this.maximalNumberOfIndividuals = number;
        }
    }

    public Integer getPropertyMaximalNumberOfIndividuals() {
        return new Integer(this.maximalNumberOfIndividuals);
    }

    public String getShortDescriptionForMaximalNumberOfIndividuals() {
        return "Maximal number of individuals";
    }

    public String getLongDescriptionForMaximalNumberOfIndividuals() {
        return "Sets the maximal number of individuals displayed in the ParetoView. If more individuals are to be displayed, only the first ones are shown.";
    }

    class ParetoViewPanel
    extends JPanel {
        public static final double X_SCALE = 0.8;
        public static final int MAX_POINT_SIZE = 8;
        private Insets insets;
        private int currentWidth;
        private int currentHeight;
        private Graphics graphics;
        private ParetoFront ParetoView;

        public ParetoViewPanel(ParetoFront ParetoView) {
            this.ParetoView = ParetoView;
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.graphics = g;
            this.insets = this.getInsets();
            this.currentWidth = this.getWidth() - this.insets.left - this.insets.right;
            this.currentHeight = this.getHeight() - this.insets.top - this.insets.bottom;
            g.setColor(Color.black);
            this.drawSearchSpace();
            ParetoFront paretoFront = this.ParetoView;
            synchronized (paretoFront) {
                IndividualList individuals = this.ParetoView.getIndividualList();
                if (individuals != null) {
                    Individual individual;
                    int maxSize = 0;
                    int minSize = 0;
                    int minFitness = 0;
                    int maxFitness = 0;
                    int i = 0;
                    while (i < individuals.size()) {
                        individual = individuals.getIndividual(i);
                        int size = ((BooleanFunctionGenotype)individual.getGenotype()).evaluateSize();
                        int fitness = ((BooleanFunctionGenotype)individual.getGenotype()).evaluate();
                        if (i == 0) {
                            minSize = size;
                            minFitness = fitness;
                        }
                        if (size > maxSize) {
                            maxSize = size;
                        }
                        if (size < minSize) {
                            minSize = size;
                        }
                        if (fitness > maxFitness) {
                            maxFitness = fitness;
                        }
                        if (fitness < minFitness) {
                            minFitness = fitness;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < individuals.size()) {
                        individual = individuals.getIndividual(i);
                        g.setColor(this.ParetoView.getColorByFitness(individual));
                        this.drawIndividual(maxFitness, minFitness, maxSize, minSize, ((BooleanFunctionGenotype)individual.getGenotype()).evaluate(), ((BooleanFunctionGenotype)individual.getGenotype()).evaluateSize());
                        ++i;
                    }
                }
                if (this.ParetoView.displayOptimum) {
                    try {
                        Genotype optimum = this.ParetoView.getSchedule().getFitnessFunction().getGenotypeOptimum();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
            }
        }

        private void drawSearchSpace() {
            this.graphics.setColor(Color.black);
            int y = 0;
            while (y <= this.currentHeight) {
                this.drawPixel(this.insets.left, y + this.insets.top);
                ++y;
            }
            int x = 0;
            while (x <= this.currentWidth) {
                this.drawPixel(x + this.insets.left, this.currentHeight + this.insets.top);
                ++x;
            }
            this.graphics.drawLine(this.currentWidth + this.insets.left - 5, this.currentHeight + this.insets.top - 5, this.currentWidth + this.insets.left, this.currentHeight + this.insets.top);
            this.graphics.drawLine(this.currentWidth + this.insets.left - 5, this.currentHeight + this.insets.top + 5, this.currentWidth + this.insets.left, this.currentHeight + this.insets.top);
            this.graphics.drawString("Fitness", this.currentWidth - 30, this.currentHeight);
            this.graphics.drawLine(this.insets.left - 5, this.insets.top + 5, this.insets.left, this.insets.top);
            this.graphics.drawLine(this.insets.left + 5, this.insets.top + 5, this.insets.left, this.insets.top);
            this.graphics.drawString("Gr\u02c6\ufb02e", this.insets.left + 10, this.insets.top + 10);
        }

        private void drawXAchsenBeschriftung(int minFitness, int maxFitness) {
            this.graphics.setColor(Color.black);
            int diff = maxFitness - minFitness;
            float i = 0.0f;
            while (i < 4.0f) {
                this.graphics.drawLine((int)((double)this.currentWidth * ((double)(i + 1.0f) / 4.0)), this.currentHeight + 5, (int)((double)this.currentWidth * ((double)(i + 1.0f) / 4.0)), this.currentHeight + 10);
                if (i == 0.0f) {
                    this.graphics.drawString(Integer.toString(maxFitness - diff), (int)((double)this.currentWidth * ((double)(i + 1.0f) / 4.0) - 10.0), this.currentHeight + 20);
                } else {
                    this.graphics.drawString(Integer.toString((int)((double)(maxFitness - diff) + (double)diff * ((double)i / 3.0))), (int)((double)this.currentWidth * ((double)(i + 1.0f) / 4.0) - 10.0), this.currentHeight + 20);
                }
                i += 1.0f;
            }
        }

        private void drawYAchsenBeschriftung(int minSize, int maxSize) {
            this.graphics.setColor(Color.black);
            int diff = maxSize - minSize + 1;
            float i = 1.0f;
            while (i <= (float)diff) {
                this.graphics.drawLine(this.insets.left - 5, (int)((float)this.insets.top + (float)this.currentHeight * (((float)diff - i) / (float)diff)), this.insets.left + 5, (int)((float)this.insets.top + (float)this.currentHeight * (((float)diff - i) / (float)diff)));
                this.graphics.drawString(Integer.toString(maxSize - (diff - (int)i)), this.insets.left - 10, (int)((float)this.insets.top + (float)this.currentHeight * (((float)diff - i) / (float)diff)));
                i += 1.0f;
            }
        }

        private int getXDeviation(int y) {
            return (int)(Math.sin(Math.PI * ((double)y / (double)this.currentHeight)) * this.getXScale());
        }

        private double getXScale() {
            return (double)this.currentWidth * 0.4;
        }

        private Point getDisplayCoordinates(boolean[] b) {
            int onemax = 0;
            int i = 0;
            while (i < b.length) {
                if (b[i]) {
                    ++onemax;
                }
                ++i;
            }
            int sumOfIndices = 0;
            int i2 = 0;
            while (i2 < b.length) {
                if (b[i2]) {
                    sumOfIndices += i2;
                }
                ++i2;
            }
            int minimalSumOfIndices = (onemax - 1) * onemax / 2;
            int maximalSumOfIndices = (b.length - 1) * b.length / 2 - (b.length - 1 - onemax) * (b.length - onemax) / 2;
            int range = maximalSumOfIndices - minimalSumOfIndices;
            int x = 2 * sumOfIndices - 2 * minimalSumOfIndices - range;
            int centerX = this.insets.left + this.currentWidth / 2;
            int yOffset = (int)((double)((b.length - onemax) * this.currentHeight) / (double)b.length);
            int xOffset = 0;
            if (range != 0) {
                xOffset = (int)((double)(x * this.getXDeviation(yOffset)) / (double)range);
            }
            return new Point(centerX + xOffset, yOffset + this.insets.top);
        }

        private void drawIndividual(int maxFitness, int minFitness, int maxSize, int minSize, int fitness, int size) {
            int radius = this.getPointSize();
            int diffSize = maxSize - minSize + 1;
            if (maxFitness == minFitness) {
                --minFitness;
            }
            int diffFitness = maxFitness - minFitness + 1;
            Point point = new Point((int)((double)this.currentWidth / 4.0 + (double)((float)((double)this.currentWidth - (double)this.currentWidth / 4.0) / (float)diffFitness * (float)(fitness - (maxFitness - diffFitness)))), this.currentHeight + 2 * this.insets.top - (int)((float)(this.currentHeight + this.insets.top) / (float)diffSize * (float)(size - (maxSize - diffSize))));
            this.graphics.fillOval((int)point.getX() - (radius + 1) / 2 + 1, (int)point.getY() - (radius + 1) / 2, radius, radius);
            this.drawYAchsenBeschriftung(minSize, maxSize);
            this.drawXAchsenBeschriftung(minFitness, maxFitness);
        }

        private void drawPixel(int x, int y) {
            this.graphics.drawLine(x - 1, y, x + 1, y);
        }

        private int getPointSize() {
            return Math.max(1, Math.min(8, this.currentHeight / 50));
        }
    }
}

