/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;

public class BestFitness
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    public BestFitness(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
    }

    public String getName() {
        return "Best Fitness";
    }

    public String getDescription() {
        return "Computes the individuals' best fitness value.";
    }

    public Class getOutputDataType() {
        return double[].class;
    }

    public void individualList(IndividualListEvent evt) {
        Individual ind = evt.getIndividualList().getIndividualWithRank(1);
        double fitness = ((SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction()).evaluate(ind, evt.getIndividualList());
        this.updateViews(new Double(fitness));
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }
}

