/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import java.util.HashMap;
import java.util.Iterator;

public abstract class BestIndividualsInSomeTimePeriod
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    private double bestValue;
    private HashMap mapOfBestIndividuals;
    private IndividualList bestIndividualList;

    public BestIndividualsInSomeTimePeriod(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
    }

    public Class getOutputDataType() {
        return IndividualList.class;
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        IndividualList newElitists = individualList.getAllIndividualsWithRank(1);
        Individual ind = newElitists.getRandomIndividual();
        double newFitness = ((SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction()).evaluate(ind, individualList);
        if (this.mapOfBestIndividuals == null || newFitness > this.bestValue) {
            this.mapOfBestIndividuals = new HashMap();
            this.addIndividuals(newElitists);
            this.bestValue = newFitness;
        } else if (newFitness == this.bestValue) {
            this.addIndividuals(newElitists);
        }
        this.updateViews(this.bestIndividualList);
    }

    private void addIndividuals(IndividualList individuals) {
        boolean modified = false;
        Iterator iter = individuals.iterator();
        while (iter.hasNext()) {
            Individual individual = (Individual)iter.next();
            if (this.mapOfBestIndividuals.containsKey(individual.getGenotype())) continue;
            modified = true;
            this.mapOfBestIndividuals.put(individual.getGenotype(), individual);
        }
        if (modified || this.bestIndividualList == null) {
            this.bestIndividualList = new Population(this.getSchedule());
            for (Individual individual : this.mapOfBestIndividuals.values()) {
                this.bestIndividualList.addIndividual(individual);
            }
        }
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }

    public void reset() {
        this.mapOfBestIndividuals = null;
    }
}

