/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class JumpK
extends AbstractStaticSingleObjectiveFitnessFunction
implements Configurable {
    private int k = 3;

    public JumpK(Schedule schedule) {
        super(schedule);
    }

    public double evaluate(Genotype genotype) {
        int n;
        BitSet set = ((BitStringGenotype)genotype).getBitSet();
        int cardinality = set.cardinality();
        if (cardinality > (n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension()) - this.k && cardinality < n) {
            return n - cardinality;
        }
        return this.k + cardinality;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        return ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension() + this.k;
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int dim = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        BitSet bs = new BitSet(dim);
        bs.set(0, dim);
        return new BitStringGenotype(bs, dim);
    }

    public void setPropertyK(Integer k) {
        if (k > 0) {
            this.k = k;
        }
    }

    public Integer getPropertyK() {
        return new Integer(this.k);
    }

    public String getLongDescriptionForK() {
        return "The parameter k specifies the size of the gap. The gap ranges from n-k+1 to n-1.";
    }

    public String getDescription() {
        return "This fitness function contains a gap the individuals have to jump over to reach the optimum. The gap contains all individuals whose number of ones lies between n-k and n (excluded).\nIndividuals not in the gap get fitness k + OneMax.\nIndividuals inside the gap get fitness n - OneMax.";
    }

    public String getName() {
        return "JumpK";
    }
}

