/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.christofides;

import edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.matching.Matching;
import edu.ucsb.cs.jicos.applications.utilities.graph.Edge;
import edu.ucsb.cs.jicos.applications.utilities.graph.Graph;
import edu.ucsb.cs.jicos.applications.utilities.graph.GraphEuclidean;
import edu.ucsb.cs.jicos.applications.utilities.graph.GraphImpl;
import edu.ucsb.cs.jicos.applications.utilities.set.MergeFindSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class UpperBound {
    private int[][] distances;
    private ArrayList[] mst;
    private int[] tour;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$utilities$upperbounds$christofides$UpperBound;

    public UpperBound(int[][] nArray) {
        this.distances = nArray;
    }

    public UpperBound(int[][] nArray, ArrayList[] arrayListArray) {
        this.distances = nArray;
        this.mst = arrayListArray;
    }

    public int[] getTour() {
        if (this.tour != null) {
            return this.tour;
        }
        if (this.mst == null) {
            this.mst = this.getMinSpanningTree();
        }
        List[] listArray = this.getEulerGraph(this.mst);
        List list = this.getEulerWalk(listArray, 0);
        this.tour = this.getEulerTour(list);
        return this.tour;
    }

    private List[] getEulerGraph(ArrayList[] arrayListArray) {
        int n;
        ArrayList arrayList = this.getOddDegreeNodes(arrayListArray);
        Graph graph = this.getOddDegreeSubgraph(arrayList);
        int[] nArray = graph.getMinCostMaxMatch();
        List[] listArray = new LinkedList[arrayListArray.length];
        int n2 = 0;
        while (n2 < listArray.length) {
            listArray[n2] = new LinkedList();
            ++n2;
        }
        int n3 = 0;
        while (n3 < arrayListArray.length) {
            n = 0;
            while (n < arrayListArray[n3].size()) {
                int n4 = (Integer)arrayListArray[n3].get(n);
                listArray[n3].add(new Integer(n4));
                ++n;
            }
            ++n3;
        }
        n = 0;
        while (n < nArray.length) {
            Integer n5 = (Integer)arrayList.get(n);
            Integer n6 = (Integer)arrayList.get(nArray[n]);
            listArray[n5].add(n6);
            ++n;
        }
        return listArray;
    }

    private int[] getEulerTour(List list) {
        int[] nArray = new int[this.distances.length];
        boolean[] blArray = new boolean[this.distances.length];
        int n = 0;
        while (n < blArray.length) {
            blArray[n] = false;
            ++n;
        }
        int n2 = 0;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            int n3 = (Integer)listIterator.next();
            if (blArray[n3]) continue;
            blArray[n3] = true;
            nArray[n2++] = n3;
        }
        if (!$assertionsDisabled && n2 != this.distances.length) {
            throw new AssertionError((Object)(n2 + " != " + this.distances.length));
        }
        return nArray;
    }

    private List getEulerWalk(List[] listArray, int n) {
        Object object;
        Object object2;
        int n2;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(new Integer(n));
        if (listArray[n].isEmpty()) {
            return linkedList;
        }
        int n3 = n;
        do {
            object2 = listArray[n3].listIterator(0);
            object = (Integer)object2.next();
            object2.remove();
            n2 = (Integer)object;
            listArray[n2].remove(new Integer(n3));
            linkedList.add((Integer)object);
        } while ((n3 = n2) != n);
        linkedList.remove(linkedList.size() - 1);
        object2 = new LinkedList();
        object = linkedList.listIterator();
        while (object.hasNext()) {
            n2 = (Integer)object.next();
            List list = this.getEulerWalk(listArray, n2);
            object2.addAll(list);
        }
        object2.add(new Integer(n));
        return object2;
    }

    private ArrayList[] getMinSpanningTree() {
        int n;
        int n2 = this.distances.length;
        ArrayList[] arrayListArray = new ArrayList[n2];
        Object[] objectArray = new Edge[n2 * (n2 - 1) / 2];
        MergeFindSet mergeFindSet = new MergeFindSet(this.distances.length);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < n3) {
                Edge edge = new Edge(n3, n, this.distances[n3][n]);
                objectArray[n4++] = edge;
                ++n;
            }
            ++n3;
        }
        Arrays.sort(objectArray);
        n = 0;
        while (n < n2) {
            arrayListArray[n] = new ArrayList();
            ++n;
        }
        int n5 = 0;
        int n6 = n2;
        while (n6 > 1) {
            int n7;
            Object object = objectArray[n5];
            int n8 = ((Edge)object).getU();
            int n9 = ((Edge)object).getV();
            int n10 = mergeFindSet.find(n8);
            if (n10 != (n7 = mergeFindSet.find(n9))) {
                mergeFindSet.merge(n10, n7);
                --n6;
                arrayListArray[n8].add(new Integer(n9));
                arrayListArray[n9].add(new Integer(n8));
            }
            ++n5;
        }
        return arrayListArray;
    }

    private ArrayList getOddDegreeNodes(ArrayList[] arrayListArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n < arrayListArray.length) {
            if (arrayListArray[n].size() % 2 == 1) {
                arrayList.add(new Integer(n));
            }
            ++n;
        }
        return arrayList;
    }

    private Graph getOddDegreeSubgraph(ArrayList arrayList) {
        int n = arrayList.size();
        int[][] nArray = new int[n][n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2][n2] = 0;
            Integer n3 = (Integer)arrayList.get(n2);
            int n4 = 0;
            while (n4 < n2) {
                Integer n5 = (Integer)arrayList.get(n4);
                int n6 = this.distances[n3][n5];
                nArray[n4][n2] = n6;
                nArray[n2][n4] = n6;
                ++n4;
            }
            ++n2;
        }
        return new GraphImpl(nArray);
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = Integer.parseInt(stringArray[3]);
        boolean bl = n4 == 0;
        UpperBound.compareToMatching(n, n2, n3, bl);
    }

    private static void compareToMatching(int n, int n2, int n3, boolean bl) {
        if (bl) {
            System.out.println("Random GENERAL graphs.");
        } else {
            System.out.println("Random EUCLIDEAN graphs.");
        }
        System.out.println("\tNodes\tcCost\tTime\tmCost\tTime");
        float f = 0.0f;
        int n4 = n;
        while (n4 <= n2) {
            int n5;
            int n6 = n5 = n4;
            int n7 = 1000;
            Graph graph = bl ? new GraphImpl(n5, n6, n7) : new GraphEuclidean(n5, n6, n7);
            int[][] nArray = graph.getCosts();
            System.out.print("\t" + n4);
            UpperBound upperBound = new UpperBound(nArray);
            long l = System.currentTimeMillis();
            int[] nArray2 = upperBound.getTour();
            long l2 = System.currentTimeMillis();
            int n8 = UpperBound.getCost(nArray2, nArray);
            System.out.print("\t" + n8 + ",\t" + (l2 - l));
            Matching matching = new Matching(nArray);
            l = System.currentTimeMillis();
            matching.setTour();
            l2 = System.currentTimeMillis();
            nArray2 = matching.getTour();
            int n9 = UpperBound.getCost(nArray2, nArray);
            float f2 = (float)n9 / (float)n8;
            System.out.println(",\t" + n9 + ",\t" + (l2 - l) + ",\t" + f2);
            if (f2 > f) {
                f = f2;
            }
            n4 += n3;
        }
        System.out.println("Maximum ratio: " + f);
    }

    private static int getCost(int[] nArray, int[][] nArray2) {
        int n = 0;
        int n2 = nArray[0];
        int n3 = 1;
        while (n3 < nArray.length) {
            n += nArray2[n2][nArray[n3]];
            n2 = nArray[n3];
            ++n3;
        }
        return n += nArray2[n2][nArray[0]];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$utilities$upperbounds$christofides$UpperBound == null ? (class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$utilities$upperbounds$christofides$UpperBound = UpperBound.class$("edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.christofides.UpperBound")) : class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$utilities$upperbounds$christofides$UpperBound).desiredAssertionStatus();
    }
}

