/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.selection;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractMultiObjectiveFitnessFunction;
import freak.core.fitness.MultiObjectiveFitnessFunction;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.GraphException;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Selection;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import java.util.Iterator;

public class ParetoFrontSelection
extends Selection
implements CompatibleWithDifferentSearchSpaces {
    public ParetoFrontSelection(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addInPort();
        super.addOutPort();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof MultiObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This operator works on multi objective fitness functions only.");
        }
    }

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        IndividualList[] result = new IndividualList[1];
        if (input[1].size() == 0) {
            result[0] = input[0];
            return result;
        }
        IndividualList[] current = new IndividualList[]{input[0]};
        Iterator it2 = input[1].iterator();
        while (it2.hasNext()) {
            boolean isDominated = false;
            Individual currentInd = (Individual)it2.next();
            MultiObjectiveFitnessFunction ff = (MultiObjectiveFitnessFunction)this.getOperatorGraph().getSchedule().getFitnessFunction();
            double[] fitness = ff.evaluate(currentInd, input[0]);
            int[] comp = new int[current[0].size()];
            Iterator it = current[0].iterator();
            int i = 0;
            while (it.hasNext()) {
                Individual ind = (Individual)it.next();
                double[] fitness2 = ff.evaluate(ind, current[0]);
                comp[i] = AbstractMultiObjectiveFitnessFunction.compare(fitness2, fitness);
                if (comp[i] >= 0) {
                    isDominated = true;
                }
                ++i;
            }
            if (isDominated) continue;
            Population pop = new Population(this.getOperatorGraph().getSchedule());
            IndividualList[] current2 = new IndividualList[]{pop};
            pop.addIndividual(currentInd);
            it = current[0].iterator();
            i = 0;
            while (it.hasNext()) {
                Individual ind = (Individual)it.next();
                if (comp[i] == -2) {
                    pop.addIndividual(ind);
                }
                ++i;
            }
            current[0] = current2[0];
        }
        result = current;
        return result;
    }

    public String getName() {
        return "Pareto Front Selection";
    }

    public String getDescription() {
        return "This selection operator iterates through all individuals in the second inport.It first checks whether the next individual in the list is dominated by any individual contained in the current population or not. In the latter case the individual is added to the population and all individuals that are dominated by it are removed.";
    }
}

