/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.selection;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Selection;
import freak.core.modulesupport.Configurable;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.NoSuchIndividualException;
import freak.core.population.Population;

public class UniformSelection
extends Selection
implements Configurable,
CompatibleWithDifferentSearchSpaces {
    private int noOfIndividualsToSelect = 1;

    public UniformSelection(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addOutPort();
    }

    public IndividualList[] process(IndividualList[] original) {
        int i = 0;
        while (i < original.length) {
            if (original[i] == null) {
                throw new NoSuchIndividualException();
            }
            ++i;
        }
        IndividualList[] result = new IndividualList[]{new Population(this.graph.getSchedule(), this.noOfIndividualsToSelect)};
        Individual[] origin = original[0].toArray();
        if (origin.length == 0) {
            return result;
        }
        RandomElement randomGen = this.graph.getSchedule().getRandomElement();
        int i2 = 0;
        while (i2 < this.noOfIndividualsToSelect) {
            int number = randomGen.choose(0, origin.length - 1);
            result[0].addIndividual(origin[number]);
            ++i2;
        }
        return result;
    }

    public Integer getPropertyNoOfIndividualsToSelect() {
        return new Integer(this.noOfIndividualsToSelect);
    }

    public void setPropertyNoOfIndividualsToSelect(Integer noOfIndividualsToSelect) {
        this.noOfIndividualsToSelect = noOfIndividualsToSelect;
        if (this.noOfIndividualsToSelect <= 0) {
            this.noOfIndividualsToSelect = 1;
        }
    }

    public String getShortDescriptionForNoOfIndividualsToSelect() {
        return "Selected individuals";
    }

    public String getLongDescriptionForNoOfIndividualsToSelect() {
        return "The number of individuals to be selected.";
    }

    public String getName() {
        return "Uniform Selection";
    }

    public String getDescription() {
        return "Selects individuals uniform random distributed among the individuals.";
    }
}

