/*
 * Decompiled with CFR 0.152.
 */
package freak.module.mapper.graphedgeselection;

import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.mapper.AbstractMapper;
import freak.core.population.Genotype;
import freak.core.searchspace.SearchSpace;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;
import freak.module.searchspace.GraphEdgeSelection;
import freak.module.searchspace.GraphEdgeSelectionGenotype;

public class RootTreeMapper
extends AbstractMapper
implements BatchEventListener {
    private GeneralString genotypeSearchSpace;

    public RootTreeMapper(Schedule schedule) {
        super(schedule);
    }

    public void initialize() {
        super.initialize();
        try {
            int dim = ((GraphEdgeSelection)this.schedule.getPhenotypeSearchSpace()).getDimension();
            if (this.genotypeSearchSpace == null || this.genotypeSearchSpace.getDimension() != dim) {
                this.createGenotypeSearchSpace();
            }
        }
        catch (IllegalStateException exc) {
            this.genotypeSearchSpace = new GeneralString(this.schedule);
        }
    }

    private void createGenotypeSearchSpace() {
        this.genotypeSearchSpace = new GeneralString(this.schedule);
        GraphEdgeSelection phenotypeSearchSpace = (GraphEdgeSelection)this.schedule.getPhenotypeSearchSpace();
        int numberOfNodes = phenotypeSearchSpace.getDimension();
        this.genotypeSearchSpace.setPropertyDimension(new Integer(numberOfNodes - 1));
        this.genotypeSearchSpace.setPropertyNumberOfChars(new Integer(numberOfNodes - 1));
        this.schedule.callInitialize();
    }

    public SearchSpace getGenotypeSearchSpace() {
        return this.genotypeSearchSpace;
    }

    public Genotype genotypeToPhenotype(Genotype genotype) {
        GraphEdgeSelection ss = (GraphEdgeSelection)this.schedule.getPhenotypeSearchSpace();
        GraphEdgeSelection.Graph graph = ss.getGraph();
        GraphEdgeSelectionGenotype gene = new GraphEdgeSelectionGenotype(graph);
        boolean[] edgeSelection = gene.getEdgeSelection();
        int[] rootDirectedTree = ((GeneralStringGenotype)genotype).getIntArray();
        int i = 0;
        while (i < rootDirectedTree.length) {
            if (rootDirectedTree[i] == i + 1) {
                rootDirectedTree[i] = rootDirectedTree.length;
            }
            if (!graph.containsEdge(i + 1, rootDirectedTree[i])) {
                return new GraphEdgeSelectionGenotype(graph);
            }
            edgeSelection[graph.findEdgeSelectionIndexForEdge((int)(i + 1), (int)rootDirectedTree[i])] = true;
            ++i;
        }
        gene.setEdgeSelection(edgeSelection);
        return gene;
    }

    public String getName() {
        return "Root Directed Tree (General String)";
    }

    public String getDescription() {
        return "Complete graphs are recommended.";
    }

    public void batchStarted(BatchEvent evt) {
        this.createGenotypeSearchSpace();
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
    }
}

