% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cop_Cont1.R
\name{copulaCont1}
\alias{copulaCont1}
\title{Fitting Linear Models with One Enedogenous Regressor using Gaussian Copula}
\usage{
copulaCont1(y, X, P, param = NULL, intercept = NULL, data = NULL)
}
\arguments{
\item{y}{a vector or matrix containing the dependent variable.}

\item{X}{a data frame or matrix containing the regressors of the model, both exogeneous and endogeneous. The last column should contain the endogeneous variable.}

\item{P}{a vector containing the continuous, non-normally distributed endogeneous variable.}

\item{param}{Initial values for the parameters to be optimized over.}

\item{intercept}{It should be specified whether the model should be estimated with or without intercept. 
If no intercept is desired or the regressors matrix \code{X} contains already
a column of ones, intercept should be given the value "FALSE", otherwise the value "TRUE".}

\item{data}{optional data frame or matrix containing the variables of the model.}
}
\value{
Returns a list with the best set of parameters found.
}
\description{
Estimates a linear model with one endogenous variable using Gaussian copula. The optimization is done via maximum likelihood, using the BFLG algorithm.
}
\keyword{copula}
\keyword{instrumental}
\keyword{internal}
\keyword{variables}
