/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents;

import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Simulator;

public abstract class Continuous {
    boolean active;
    double value;
    Event ev;
    double phi;
    double pi;
    double buffer;
    double sum;
    private Simulator sim;

    public Continuous() {
        this.active = false;
        this.sim = Simulator.getDefaultSimulator();
    }

    public Continuous(Simulator simulator) {
        if (simulator == null) {
            throw new NullPointerException();
        }
        this.active = false;
        this.sim = simulator;
    }

    public void init(double d) {
        this.value = d;
    }

    public double value() {
        return this.value;
    }

    public Simulator simulator() {
        return this.sim;
    }

    public void setSimulator(Simulator simulator) {
        if (simulator == null) {
            throw new NullPointerException();
        }
        this.sim = simulator;
    }

    public void startInteg() {
        this.sim.continuousState().startInteg(this);
    }

    public void startInteg(double d) {
        this.init(d);
        this.startInteg();
    }

    public void stopInteg() {
        this.sim.continuousState().stopInteg(this);
    }

    public abstract double derivative(double var1);

    public void afterEachStep() {
    }

    public static void selectEuler(double d) {
        Simulator.getDefaultSimulator().continuousState().selectEuler(d);
    }

    public static void selectRungeKutta4(double d) {
        Simulator.getDefaultSimulator().continuousState().selectRungeKutta4(d);
    }

    public static void selectRungeKutta2(double d) {
        Simulator.getDefaultSimulator().continuousState().selectRungeKutta2(d);
    }
}

