/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class JohnsonSUDist
extends ContinuousDistribution {
    private double gamma;
    private double delta;
    private double xi;
    private double lambda;

    private static double calcR(double d, double d2, double d3) {
        boolean bl;
        double d4 = (d3 - d) / d2;
        if (d4 < 0.0) {
            d4 = -d4;
            bl = true;
        } else {
            bl = false;
        }
        double d5 = d4 < 1.0E10 ? d4 + Math.sqrt(1.0 + d4 * d4) : 2.0 * d4;
        if (bl) {
            d5 = 1.0 / d5;
        }
        return d5;
    }

    public JohnsonSUDist(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        this.gamma = d;
        this.delta = d2;
        this.xi = 0.0;
        this.lambda = 1.0;
    }

    public JohnsonSUDist(double d, double d2, double d3, double d4) {
        this.setParams(d, d2, d3, d4);
    }

    public double density(double d) {
        return JohnsonSUDist.density(this.gamma, this.delta, this.xi, this.lambda, d);
    }

    public double cdf(double d) {
        return JohnsonSUDist.cdf(this.gamma, this.delta, this.xi, this.lambda, d);
    }

    public double inverseF(double d) {
        return JohnsonSUDist.inverseF(this.gamma, this.delta, this.xi, this.lambda, d);
    }

    public double getMean() {
        return JohnsonSUDist.getMean(this.gamma, this.delta, this.xi, this.lambda);
    }

    public double getVariance() {
        return JohnsonSUDist.getVariance(this.gamma, this.delta, this.xi, this.lambda);
    }

    public double getStandardDeviation() {
        return JohnsonSUDist.getStandardDeviation(this.gamma, this.delta, this.xi, this.lambda);
    }

    public static double density(double d, double d2, double d3, double d4, double d5) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double d6 = JohnsonSUDist.calcR(d3, d4, d5);
        if (d6 <= 0.0) {
            return 0.0;
        }
        double d7 = d + d2 * Math.log(d6);
        double d8 = (d5 - d3) / d4;
        return d2 / (d4 * Math.sqrt(Math.PI * 2) * Math.sqrt(d8 * d8 + 1.0)) * Math.exp(-d7 * d7 / 2.0);
    }

    public static double cdf(double d, double d2, double d3, double d4, double d5) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double d6 = JohnsonSUDist.calcR(d3, d4, d5);
        if (d6 > 0.0) {
            return NormalDist.cdf01(d + d2 * Math.log(d6));
        }
        return 0.0;
    }

    public static double barF(double d, double d2, double d3, double d4, double d5) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double d6 = JohnsonSUDist.calcR(d3, d4, d5);
        if (d6 > 0.0) {
            return NormalDist.barF01(d + d2 * Math.log(d6));
        }
        return 1.0;
    }

    public static double inverseF(double d, double d2, double d3, double d4, double d5) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (d5 > 1.0 || d5 < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d5 >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d5 <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d6 = NormalDist.inverseF01(d5);
        double d7 = (d6 - d) / d2;
        if (d7 >= 709.782712893384) {
            return Double.POSITIVE_INFINITY;
        }
        if (d7 <= -707.7032713517042) {
            return Double.NEGATIVE_INFINITY;
        }
        return d3 + d4 * Math.sinh(d7);
    }

    public static double getMean(double d, double d2, double d3, double d4) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        return d3 - d4 * Math.exp(1.0 / (2.0 * d2 * d2)) * Math.sinh(d / d2);
    }

    public static double getVariance(double d, double d2, double d3, double d4) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double d5 = Math.exp(1.0 / (d2 * d2));
        return (d5 - 1.0) * (d5 * Math.cosh(2.0 * d / d2) + 1.0) / 2.0;
    }

    public static double getStandardDeviation(double d, double d2, double d3, double d4) {
        return Math.sqrt(JohnsonSUDist.getVariance(d, d2, d3, d4));
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getXi() {
        return this.xi;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double d, double d2, double d3, double d4) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        this.gamma = d;
        this.delta = d2;
        this.xi = d3;
        this.lambda = d4;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.gamma, this.delta, this.xi, this.lambda};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : gamma = " + this.gamma + ", delta = " + this.delta + ", xi = " + this.xi + ", lambda = " + this.lambda;
    }
}

