% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel-api.R
\name{kernel_api}
\alias{kernel_api}
\title{REDCapR internal function for calling the REDCap API}
\usage{
kernel_api(redcap_uri, post_body, config_options)
}
\arguments{
\item{redcap_uri}{The URI (uniform resource identifier) of the REDCap project.  Required.}

\item{post_body}{List of contents expected by the REDCap API.  Required.}

\item{config_options}{A list of options to pass to \code{POST} method in the \code{httr} package.  See the details below.  Optional.}
}
\value{
A \link[utils:packageVersion]{utils::packageVersion}.
}
\description{
This function is used by other functions to read and write values.
}
\details{
If the API call is unsuccessful, a value of \code{base::package_version("0.0.0")} will be returned.
This ensures that a the function will always return an object of class \link[base:package_version]{base::package_version}.
It guarantees the value can always be used in \code{\link[utils:compareVersion]{utils::compareVersion()}}.
}
\examples{
config_options <- NULL
uri            <- "https://bbmc.ouhsc.edu/redcap/api/"
token          <- "9A81268476645C4E5F03428B8AC3AA7B"
post_body      <- list(
  token    = token,
  content  = 'project',
  format   = 'csv'
)
kernel <- REDCapR:::kernel_api(uri, post_body, config_options)

# Consume the results in a few different ways.
kernel$result
read.csv(text=kernel$raw_text, stringsAsFactors=FALSE)
as.list(read.csv(text=kernel$raw_text, stringsAsFactors=FALSE))
}
