% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_query.R
\name{rd_query}
\alias{rd_query}
\title{Identification of queries}
\usage{
rd_query(
  variables = NA,
  expression = NA,
  negate = FALSE,
  variables_names = NA,
  query_name = NA,
  instrument = NA,
  event = NA,
  dic,
  data,
  filter = NA,
  addTo = NA,
  report_title = NA,
  report_zeros = FALSE
)
}
\arguments{
\item{variables}{Vector with variables names from the database that will be checked. If this argument alongside with the argument `expression` are unspecified, this function will look for abnormal values using the minimum and maximum of each variable in the dataset (information contained in the dictionary).}

\item{expression}{Expression that will be applied to the chosen variables, for example, "<170". If this argument is unspecified, this function will look for abnormal values using the minimum and maximum of each variable in the dataset (information contained in the dictionary).}

\item{negate}{Logical value indicating whether or not to negate the defined expression. Defaults to `FALSE`.}

\item{variables_names}{Vector with the description of each variable. By default, the function will automatically pick the description of each variable from the dictionary of the dataset.}

\item{query_name}{Description of the query. It can be defined as the same one for all variables or you can define one for each variable. By default, the function will define the description as `The value is [value] and it should not be [expression]' for each one of the variables`.}

\item{instrument}{REDCap's instrument to which the variables belong. It can be defined as the same one for all variables or you can define one for each variable. By default, the function will automatically pick the corresponding instrument of each variable from the dictionary of the dataset.}

\item{event}{REDCap's event name to be analyzed. If your REDCap project has events, you should use this argument in order to name the event to which the defined variables belong.}

\item{dic}{R object corresponding to the dictionary of the dataset.}

\item{data}{R object corresponding to the dataset.}

\item{filter}{A filter to apply to the dataset. This argument can be used to, for example, apply the branching logic of a determined variable.}

\item{addTo}{Data frame corresponding to a prior report of queries to which you can add the new data frame of queries. By default, the function will always generate a new data frame without taking into account former reports.}

\item{report_title}{Character string with the report's title.}

\item{report_zeros}{Logical. If `TRUE`, it returns a report including variables with zero queries.}
}
\value{
A list with a data frame with 9 columns meant to help the user identify each query and a table with the total of queries per variable.
}
\description{
This function allows you to identify queries using a determined expression.
It can be used to identify missing values, values outside the lower or upper limit of a variable and even identify missing values of variables that present a branching logic through the use of the filter argument.
}
\examples{
# Missings
example <- rd_query(variables = c("copd", "age"),
                    expression = c("\%in\%NA", "\%in\%NA"),
                    event = "initial_visit_arm_1",
                    dic = covican$dictionary,
                    data = covican$data)
example

# Expression
example <- rd_query(variables="age",
                    expression=">20",
                    event="initial_visit_arm_1",
                    dic=covican$dictionary,
                    data=covican$data)
example

# Using a filter
example <- rd_query(variables = "potassium",
                    expression = "\%in\%NA",
                    event = "initial_visit_arm_1",
                    dic = covican$dictionary,
                    data = covican$data,
                    filter = "analitica_disponible=='1'")
example
}
