% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomorfo.R
\name{geomorfo}
\alias{geomorfo}
\title{Geomorphological division of the Czech Republic}
\source{
CENIA / INSPIRE, via Mgr. Vojtěch Blažek, Ph.D. \url{https://www.arcgis.com/home/item.html?id=25813686a8564b0bbcdc951a5573cfa4}
}
\usage{
geomorfo(level)
}
\arguments{
\item{level}{level of geomorphological division. One of system, subsystem, provincie, subprovincie, oblast, celek, podcelek, okrsek.}
}
\value{
\code{sf} data frame with geomorfo division names & codes + geometry; namely:

\describe{
\item{system}{name of the system; 2 rows}
\item{subsystem}{names of the system, subsystem + kod; 4 rows}
\item{provincie}{name of the province; 4 rows}
\item{subprovincie}{name of the subprovince + kod; 10 rows}
\item{oblast}{name of the subprovince, oblast + kod; 27 rows}
\item{celek}{name of the subprovince, oblast, celek + kod; 93 rows}
\item{podcelek}{name of the subprovince, oblast, celek, podcelek + kod; 253 rows}
\item{okrsek}{name of the subprovince, oblast, celek, podcelek, okrsek  + kod; 933 rows}
}
}
\description{
Function returning one of the 8 levels of Geomorphological division of the Czech Republic, as specified by the obligatory parameter \strong{level}.
}
\details{
Due to package size constraints the data are stored externally (and a working internet connection is required to use the package).

The data is current to 2014 (3rd edition of Demek & Mackovčin's \emph{Zeměpisný lexikon ČR. Hory a nížiny.}) Downloaded size is < 1 MB for any of the hierarchy levels.
}
\examples{

\donttest{
library(sf)

soustavy <- RCzechia::geomorfo("subprovincie")

plot(soustavy["kod"])

}

}
