% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MultiPhasesGap}
\alias{MultiPhasesGap}
\title{Gap/Hiatus between a succession of phases (for phases in temporal order constraint)}
\usage{
MultiPhasesGap(file, position, level = 0.95, max_decimal = 0,
dec = '.', sep=',', comment.char='#')
}
\arguments{
  \item{file}{name of the CSV file containing the output of the MCMC algorithm of all phases of interest}
  \item{position}{numeric vector containing the position of the beginning of the phases of interest in the CSV file in the order of the succession}
  \item{level}{probability corresponding to the level of confidence}
  \item{max_decimal}{maximum number of decimal}
  \item{dec}{the character used in the file for decimal points for the use of read.csv()}
  \item{sep}{the field separator character for the use of read.csv()}
  \item{comment.char}{a character vector of length one containing a single character or an empty string for the use of read.csv()}
}
\value{
Returns a matrix of values containing the level of confidence and the endpoints of the gap for each pair of successive phases
}
\description{
This function finds, if it exists, the gap between two successive phases. This gap or hiatus is the longest interval [IntervalInf, IntervalSup] that satisfies : P(Phase1End < IntervalInf < IntervalSup < Phase2Beginning | M) = level.
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Phases)
  write.csv(Phases, "data.csv")
  MultiPhasesGap("data.csv", c(4,2), 0.95, 0)
}
\keyword{ bayesian statistics }
\keyword{ gap between two phases}
\keyword{ temporal order }
