% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainFunctions.R
\name{SimS}
\alias{SimS}
\title{Calculate the initial similarity matrix}
\usage{
SimS(
  data,
  pcRatio = 0.95,
  gamma = 0.8,
  NN.method = "KNN",
  Dis.method = "Euclidean",
  LSH.TreeNum = 30,
  LSH.Dim = 1000,
  LSH.Dis = "angular",
  neiRatio = 0.65
)
}
\arguments{
\item{data}{gene expression matrix after genes filtering}

\item{pcRatio}{the ratio between the variance of the}

\item{gamma}{the ratio of the global simialrity}

\item{NN.method}{the method of finding neighbors}

\item{Dis.method}{the distance metric in finding neighbors}

\item{LSH.TreeNum}{the tree number of LSH}

\item{LSH.Dim}{the dimension in LSH}

\item{LSH.Dis}{the distance metric in LSH}

\item{neiRatio}{ratio of the number of selected}
}
\value{
initial similarity matrix S

gene expression matrix after PCA processing drData
}
\description{
Calculate the initial similarity matrix
}
\examples{
gfData <- GenesFilter(yan[1:100,1:15])
res_Sims <- SimS(gfData)
res_Sims$S
res_Sims$res_pca

}
