% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.functions.r
\name{logregR2}
\alias{logregR2}
\title{Logistic regression model fit statistics}
\usage{
logregR2(model, digits = 3)
}
\arguments{
\item{model}{An estimated logistic regression model (a glm or svyglm object)}

\item{digits}{Number of digits to be displayed after decimal points}
}
\value{
Returns list of statistics about model (a "LogRegR2" class object)
}
\description{
Logistic regression model statistics, reported by logregC with fit.stats=TRUE argument, can be used for both weighted and unweighted logregC models.
}
\examples{
   library(RCPA3)
   
   \donttest{
   logit.model <- logregC(states$battleground2020 ~ states$vep16.turnout)
   logregR2(logit.model)
   }
}
\keyword{internal}
