% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosstabC.r
\name{crosstabC}
\alias{crosstabC}
\title{Cross-tabulation analysis, option for weighting observations, makes controlled comparisons, generates plots, performs Chi-Square test, measures strength of association}
\usage{
crosstabC(dv, iv, w, z, data, digits = 2, compact = FALSE, dvlabs, ivlabs,
  zlabs, chisq = FALSE, lambda = FALSE, somers = FALSE,
  cramers = FALSE, printC = FALSE, plot = TRUE, plot.response, main,
  xlab, ylab, z.palette, legend.title)
}
\arguments{
\item{dv}{Dependent variable, should be in dataset$var form unless dataset specified in optional data argument. Should be a nominal or ordinal-level variable.}

\item{iv}{Independent variable, should be in dataset$var form unless dataset specified in optional data argument. Should be a nominal or ordinal-level variable.}

\item{w}{(Optional) Sampling weights of variable, must be numeric; should be in dataset$weightvar form unless dataset specified in optional data argument.}

\item{z}{(Optional) Control variable, must be numeric; should be in dataset$weightvar form unless dataset specified in optional data argument.}

\item{data}{(Optional) Name of dataset that contains dv, iv (and w) variables.}

\item{digits}{(Optional) Number of decimal places reported in result (defaults to 2).}

\item{compact}{(Optional) Do you want compact display of cross-tabulation with row subtotals omitted? Default is FALSE.}

\item{dvlabs}{(Optional) A vector of names for the dependent variable's values (to abbreviate the cross-tabulation's row labels and dv labels on plots)}

\item{ivlabs}{(Optional) A vector of names for the independent variable's values (to abbreviate the cross-tabulation's column labels and iv labels on plots)}

\item{zlabs}{(Optional) A vector of names for the control variable's values (to abbreviate the controlled cross-tabulation's column labels and z variable labels on plots)}

\item{chisq}{(Optional) Do you want to conduct Chi-Square Test? If z argument specific, Chi-Square Test conducted on dv-iv relationship for each value of z.}

\item{lambda}{(Optional) Do you want Lambda reported? If z argument specified, Lambda reported for dv-iv relationship for each value of z.}

\item{somers}{(Optional) Do you want Somers' d reported? If z argument specific, Somers' D reported for dv-iv relationship for each value of z.}

\item{cramers}{(Optional) Do you want Cramer's V reported? If z argument specific, Cramer's V reported for dv-iv relationship for each value of z.}

\item{printC}{(Optional) Do you want to print cross-tabulation and plot (if plot is used) to .html file in working directory? (default: FALSE)}

\item{plot}{(Optional) Do you want a plot of the cross-tabulation? Default is TRUE (and makes a bar plot). Other plot options:
\itemize{
\item "line" for a line plot,
\item "mosaic" for a mosaic plot,
\item "bar", TRUE, or T for a bar plot (default plot)
\item FALSE or F to suppress plot.
}}

\item{plot.response}{(Optional) Set \code{plot.response="all"} to plot all DV values (for uncontrolled comparisons only).}

\item{main}{(Optional) Main label for plot}

\item{xlab}{(Optional) x-axislabel for plot}

\item{ylab}{(Optional) y-axis label for plot}

\item{z.palette}{(Optional) For bar and line plots with control variables (z).}

\item{legend.title}{(Optional) Title for legend shown if plot used with z argument.}
}
\value{
Returns a cross-tabulation
}
\description{
This is a workhorse function for analyzing the relationship between two variables measured at the nominal or ordinal-level (factors). Basic output is a cross-tabulation with column percentages and counts. Options include weighting observations, adding control variable for controlled cross-tabulation, several plotting options, conducting Chi-Square test of independence, and measuring strength of association.
}
\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapters 4, 5, 7, 10.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), pp.85-97, 150-156, 215-231. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=4}{Tutorials & Resources for Making Comparisons}, \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=5}{Graphing Relationships and Describing Patterns}, \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=7}{Making Controlled Comparisons}, and \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=10}{Chi-Square Test and Analysis of Variance}, compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}: Find datasets for your own research and resources to help with the analysis.
}
}

\examples{
 
  library(RCPA3)
  
  \donttest{
  crosstabC(dv=nes$death.penalty, iv=nes$partyid3)
  
  # with optional w, data, chisq, somers arguments
  crosstabC(dv=death.penalty, iv=partyid3, w=wt, data=nes, chisq=TRUE, somers=TRUE)
  
  # example with optional w, data, z, and plot="line" arguments
  crosstabC(dv=death.penalty, iv=partyid3, w=wt, data=nes, z=gender, plot="line")
  }
}
